/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.tile.machine;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import uk.joshiejack.penguinlib.block.base.AbstractDoubleBlock;
import uk.joshiejack.penguinlib.network.PenguinNetwork;
import uk.joshiejack.penguinlib.network.PenguinPacket;
import uk.joshiejack.penguinlib.network.packet.SetInventorySlotPacket;
import uk.joshiejack.penguinlib.tile.machine.AbstractSimpleMachineTileEntity;

public abstract class AbstractIRecipeMachine<I extends IRecipe<IInventory>>
extends AbstractSimpleMachineTileEntity {
    protected final IRecipeType<I> recipeType;

    public AbstractIRecipeMachine(TileEntityType<?> type, IRecipeType<I> recipeType) {
        this(type, recipeType, Objects.requireNonNull(type.getRegistryName()).toString());
    }

    public AbstractIRecipeMachine(TileEntityType<?> type, IRecipeType<I> recipeType, String time) {
        super(type, time);
        this.recipeType = recipeType;
    }

    public int func_70297_j_() {
        return ((ItemStack)this.items.get(0)).func_190926_b() ? 1 : ((ItemStack)this.items.get(0)).func_77976_d();
    }

    @Nullable
    protected I getRecipeResult(ItemStack stack) {
        for (IRecipe recipe : this.field_145850_b.func_199532_z().func_241447_a_(this.recipeType)) {
            if (!recipe.func_192400_c().stream().allMatch(ing -> ing.test(stack))) continue;
            return (I)recipe;
        }
        return null;
    }

    @Nonnull
    protected ItemStack getResult(ItemStack stack) {
        I recipe = this.getRecipeResult(stack);
        return recipe == null ? ItemStack.field_190927_a : recipe.func_77571_b();
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        return ((ItemStack)this.items.get(slot)).func_190926_b() && !this.getResult(stack).func_190926_b();
    }

    @Override
    protected boolean canStart() {
        return !this.getResult((ItemStack)this.items.get(0)).func_190926_b();
    }

    @Override
    public void finishMachine() {
        ItemStack result = ((IRecipe)Objects.requireNonNull(this.getRecipeResult((ItemStack)this.items.get(0)))).func_77572_b((IInventory)this);
        this.items.set(0, (Object)result);
        PenguinNetwork.sendToNearby((PenguinPacket)new SetInventorySlotPacket(this.field_174879_c, 0, result), this);
        this.func_70296_d();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        BlockState state = this.func_195044_w();
        if (state.func_177230_c() instanceof AbstractDoubleBlock && state.func_177229_b(AbstractDoubleBlock.HALF) == DoubleBlockHalf.UPPER) {
            TileEntity below = Objects.requireNonNull(this.field_145850_b).func_175625_s(this.field_174879_c.func_177977_b());
            BlockState belowState = Objects.requireNonNull(this.field_145850_b).func_180495_p(this.field_174879_c.func_177977_b());
            return below != null && belowState.func_177230_c() == state.func_177230_c() ? below.getCapability(cap, side) : LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }
}

