/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.util.helpers;

import com.google.common.collect.Streams;
import java.util.stream.Stream;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import org.apache.commons.lang3.mutable.MutableInt;

public class PlayerHelper {
    private static CompoundNBT getOrCreateTag(CompoundNBT base, String name) {
        if (!base.func_74764_b(name)) {
            base.func_218657_a(name, (INBT)new CompoundNBT());
        }
        return base.func_74775_l(name);
    }

    public static boolean hasTag(PlayerEntity player, String compoundTag, String tag) {
        return PlayerHelper.getOrCreateTag(player.getPersistentData(), compoundTag).func_74764_b(tag);
    }

    public static void setTag(PlayerEntity player, String compoundTag, String tag) {
        PlayerHelper.getOrCreateTag(player.getPersistentData(), compoundTag).func_74757_a(tag, true);
    }

    public static void setSubTag(PlayerEntity player, String main, String sub, String tag) {
        PlayerHelper.getOrCreateTag(PlayerHelper.getOrCreateTag(player.getPersistentData(), main), sub).func_74757_a(tag, true);
    }

    public static boolean hasSubTag(PlayerEntity player, String main, String sub, String tag) {
        return PlayerHelper.getOrCreateTag(PlayerHelper.getOrCreateTag(player.getPersistentData(), main), sub).func_74764_b(tag);
    }

    public static Stream<ItemStack> getInventoryStream(PlayerEntity player) {
        return Streams.concat((Stream[])new Stream[]{player.field_71071_by.field_70462_a.stream(), player.field_71071_by.field_70460_b.stream(), player.field_71071_by.field_184439_c.stream()});
    }

    public static boolean hasInInventory(PlayerEntity player, Ingredient ingredient, int amount) {
        return PlayerHelper.getInventoryStream(player).mapToInt(stack -> ingredient.test(stack) ? stack.func_190916_E() : 0).sum() >= amount;
    }

    public static boolean takeFromInventory(PlayerEntity player, Ingredient ingredient, int amount) {
        MutableInt taken = new MutableInt(amount);
        return PlayerHelper.getInventoryStream(player).anyMatch(stack -> {
            if (ingredient.test(stack)) {
                int take = Math.min(stack.func_190916_E(), taken.intValue());
                stack.func_190918_g(take);
                taken.subtract(take);
            }
            return taken.intValue() == 0;
        });
    }

    public static CompoundNBT getPenguinStatuses(PlayerEntity player) {
        CompoundNBT data = player.getPersistentData();
        if (!data.func_74764_b("PenguinStatuses")) {
            data.func_218657_a("PenguinStatuses", (INBT)new CompoundNBT());
        }
        return data.func_74775_l("PenguinStatuses");
    }
}

