/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.util.helpers;

import com.google.common.collect.Lists;
import java.util.stream.Collectors;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import org.apache.commons.lang3.StringUtils;

public class StringHelper {
    private static boolean unicode;

    public static String[] getListFromDatabase(String data) {
        return data.replace("\"", "").replace(", ", ",").split(",");
    }

    public static TranslationTextComponent localize(String text) {
        return new TranslationTextComponent(text);
    }

    public static TranslationTextComponent format(String text, Object ... objects) {
        return new TranslationTextComponent(text, objects);
    }

    public static boolean isEarlierThan(String name, char c) {
        return Character.toLowerCase(name.charAt(0)) < c;
    }

    public static String convertNumberToString(long number) {
        return StringHelper.convertNumberToString(number, false);
    }

    public static String convertNumberToString(long number, boolean shortform) {
        if (number < 0L) {
            number = -number;
        }
        if (number < 1000L) {
            return "" + number;
        }
        long remainder = number % 1000L;
        int decimal = remainder == 0L ? 0 : (shortform || remainder % 100L == 0L ? 1 : (remainder % 10L == 0L ? 2 : 3));
        int exp = (int)(Math.log(number) / Math.log(1000.0));
        return String.format("%." + decimal + "f%c", (double)number / Math.pow(1000.0, exp), Character.valueOf("kMGTPE".charAt(exp - 1)));
    }

    public static void enableUnicode() {
        Minecraft mc = Minecraft.func_71410_x();
        unicode = mc.field_71474_y.field_211842_aO;
        AbstractOption.field_216684_H.func_216742_a(mc.field_71474_y, "true");
    }

    public static void disableUnicode() {
        AbstractOption.field_216684_H.func_216742_a(Minecraft.func_71410_x().field_71474_y, String.valueOf(unicode));
    }

    public static String[] decompose(String namespace, char character) {
        String[] astring = new String[]{"minecraft", namespace};
        int i = namespace.indexOf(character);
        if (i >= 0) {
            astring[1] = namespace.substring(i + 1);
            if (i >= 1) {
                astring[0] = namespace.substring(0, i);
            }
        }
        return astring;
    }

    public static String join(char character, Object ... vars) {
        return StringUtils.join((Iterable)Lists.newArrayList((Object[])vars).stream().map(Object::toString).collect(Collectors.toList()), (char)character);
    }

    public static ITextComponent withClickableCommand(String command, String tooltip, Object ... formatting) {
        return StringHelper.withClickableCommand(TextFormatting.AQUA, command, tooltip, formatting);
    }

    public static ITextComponent withClickableCommand(TextFormatting color, String command, String tooltip, Object ... formatting) {
        return new TranslationTextComponent(command, formatting).func_240700_a_(p_241055_1_ -> p_241055_1_.func_240712_a_(color).func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command + StringHelper.join(' ', formatting))).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent(tooltip))));
    }
}

