/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.util.helpers;

import java.time.DayOfWeek;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="penguinlib")
public class TimeHelper {
    public static long TICKS_PER_DAY = 24000L;
    public static double SCALE = (double)TICKS_PER_DAY / 24000.0;
    public static long SIX_AM = (long)(SCALE * 6000.0);
    public static final DayOfWeek[] DAYS = DayOfWeek.values();

    public static long scaleTime(long time) {
        return (long)(SCALE * (double)time);
    }

    public static int getElapsedDays(long time) {
        return (int)(time / TICKS_PER_DAY);
    }

    public static int getElapsedDays(World world) {
        return (int)(world.func_82737_E() / TICKS_PER_DAY);
    }

    public static long getTimeOfDay(long time) {
        return (time + SIX_AM) % TICKS_PER_DAY;
    }

    public static boolean isBetween(World world, int open, int close) {
        long timeOfDay = TimeHelper.getTimeOfDay(world.func_82737_E());
        return timeOfDay >= (long)open && timeOfDay <= (long)close;
    }

    public static DayOfWeek getWeekday(long time) {
        int days = TimeHelper.getElapsedDays(time);
        int modulus = days % 7;
        if (modulus < 0) {
            modulus = 0;
        }
        return DAYS[modulus];
    }

    public static String shortName(DayOfWeek day) {
        return day.name().substring(0, 3);
    }
}

