/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.util.icon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import uk.joshiejack.penguinlib.util.icon.Icon;

public class EntityIcon
extends Icon {
    private final EntityType<?> entityType;
    @OnlyIn(value=Dist.CLIENT)
    private LivingEntity entity;
    private final int scale;

    public EntityIcon(EntityType<?> entityType, int scale) {
        this.entityType = entityType;
        this.scale = scale;
    }

    @Override
    public JsonElement toJson(JsonObject json) {
        json.addProperty("entity", this.entityType.getRegistryName().toString());
        json.addProperty("scale", (Number)this.scale);
        return json;
    }

    @Override
    public void toNetwork(PacketBuffer pb) {
        pb.writeByte(Icon.Type.ENTITY.ordinal());
        pb.writeRegistryId(this.entityType);
        pb.writeByte(this.scale);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(Minecraft mc, MatrixStack matrix, int x, int y) {
        if (this.entity == null) {
            assert (mc.field_71441_e != null);
            Entity test = this.entityType.func_200721_a((World)mc.field_71441_e);
            if (test instanceof LivingEntity) {
                this.entity = (LivingEntity)test;
            } else {
                return;
            }
        }
        InventoryScreen.func_228187_a_((int)(x + 8), (int)(y + 15), (int)this.scale, (float)-65.0f, (float)0.0f, (LivingEntity)this.entity);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<ITextComponent> getTooltipLines(PlayerEntity player) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add(this.entityType.func_212546_e());
        return list;
    }
}

