/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.util.icon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import uk.joshiejack.penguinlib.client.renderer.ShadowRenderer;
import uk.joshiejack.penguinlib.util.icon.AbstractCyclicIcon;
import uk.joshiejack.penguinlib.util.icon.Icon;

public class ListIcon
extends AbstractCyclicIcon<Icon> {
    public static final Icon EMPTY = new ListIcon((List<Icon>)new ArrayList<Icon>());

    public ListIcon(List<Icon> icons) {
        super(icons);
    }

    @Override
    public JsonElement toJson(JsonObject json) {
        JsonArray array = new JsonArray();
        for (Icon icon : this.list) {
            JsonObject data = new JsonObject();
            icon.toJson(data);
            array.add((JsonElement)data);
        }
        json.add("icon_list", (JsonElement)array);
        return json;
    }

    @Override
    public void toNetwork(PacketBuffer pb) {
        pb.writeByte(Icon.Type.ITEM_LIST.ordinal());
        pb.writeShort(this.list.size());
        this.list.forEach(icon -> icon.toNetwork(pb));
    }

    @Override
    protected void renderCyclicIcon(Minecraft mc, MatrixStack matrixStack, int x, int y) {
        if (this.shadowed) {
            ShadowRenderer.enable();
        }
        ((Icon)this.object).render(mc, matrixStack, x, y);
        if (this.shadowed) {
            ShadowRenderer.disable();
            this.shadowed = false;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<ITextComponent> getTooltipLines(PlayerEntity player) {
        return ((Icon)this.object).getTooltipLines(player);
    }
}

