/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.util.icon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import uk.joshiejack.penguinlib.util.icon.Icon;

public class TextureIcon
extends Icon {
    private static final List<ITextComponent> EMPTY_LIST = new ArrayList<ITextComponent>();
    private final ResourceLocation texture;
    private final int xPos;
    private final int yPos;

    public TextureIcon(ResourceLocation texture, int x, int y) {
        this.texture = texture;
        this.xPos = x;
        this.yPos = y;
    }

    @Override
    public JsonElement toJson(JsonObject json) {
        if (!this.texture.equals((Object)DEFAULT_LOCATION)) {
            json.addProperty("texture", this.texture.toString());
        }
        if (this.xPos != 0) {
            json.addProperty("x", (Number)this.xPos);
        }
        if (this.yPos != 0) {
            json.addProperty("y", (Number)this.yPos);
        }
        return json;
    }

    @Override
    public void toNetwork(PacketBuffer pb) {
        pb.writeByte(Icon.Type.TEXTURE.ordinal());
        if (this.texture.equals((Object)DEFAULT_LOCATION)) {
            pb.writeBoolean(false);
        } else {
            pb.writeBoolean(true);
            pb.func_192572_a(this.texture);
        }
        pb.writeInt(this.xPos);
        pb.writeInt(this.yPos);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(Minecraft mc, MatrixStack matrix, int x, int y) {
        mc.func_110434_K().func_110577_a(this.texture);
        mc.field_71456_v.func_230926_e_(0);
        mc.field_71456_v.func_238474_b_(matrix, x, y, this.xPos, this.shadowed ? this.yPos + 16 : this.yPos, 16, 16);
        this.shadowed = false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<ITextComponent> getTooltipLines(PlayerEntity player) {
        return EMPTY_LIST;
    }
}

