/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.world.teams;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.eventbus.api.Event;
import uk.joshiejack.penguinlib.events.TeamChangedOwnerEvent;
import uk.joshiejack.penguinlib.network.PenguinNetwork;
import uk.joshiejack.penguinlib.network.packet.SyncTeamDataPacket;

public class PenguinTeam
implements INBTSerializable<CompoundNBT> {
    private boolean isClient;
    private CompoundNBT data;
    private Set<UUID> members;
    private Set<UUID> invited;
    private UUID teamUUID;
    private UUID owner;
    private String name = "";

    public PenguinTeam(UUID uuid) {
        this.teamUUID = uuid;
        this.members = new HashSet<UUID>();
        this.invited = new HashSet<UUID>();
        this.data = new CompoundNBT();
    }

    public void setClient() {
        this.isClient = true;
    }

    public boolean isClient() {
        return this.isClient;
    }

    public void invite(ServerWorld level, UUID uuid) {
        this.invited.add(uuid);
    }

    public void clearInvite(UUID playerID) {
        this.invited.remove(playerID);
    }

    public boolean isInvited(UUID uuid) {
        return this.invited.contains(uuid);
    }

    public PenguinTeam onChanged(ServerWorld world) {
        if (!this.members.contains(this.owner)) {
            this.owner = this.members.stream().findFirst().orElse(null);
            MinecraftForge.EVENT_BUS.post((Event)new TeamChangedOwnerEvent(this.teamUUID, this.owner));
        }
        this.syncToTeam(world);
        return this;
    }

    public PenguinTeam(CompoundNBT data) {
        this.deserializeNBT(data);
    }

    public Set<UUID> members() {
        return this.members;
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public UUID getID() {
        return this.teamUUID;
    }

    public CompoundNBT getData() {
        return this.data;
    }

    public void syncToPlayer(ServerPlayerEntity player) {
        PenguinNetwork.sendToClient(new SyncTeamDataPacket(this.serializeNBT()), player);
    }

    public void syncToTeam(ServerWorld world) {
        PenguinNetwork.sendToTeam(new SyncTeamDataPacket(this.serializeNBT()), world, this.teamUUID);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a("UUID", this.teamUUID.toString());
        compound.func_74778_a("Name", this.name == null ? this.teamUUID.toString() : this.name);
        compound.func_218657_a("Data", (INBT)this.data);
        ListNBT list = new ListNBT();
        this.members.forEach(uuid -> list.add((Object)StringNBT.func_229705_a_((String)uuid.toString())));
        compound.func_218657_a("Members", (INBT)list);
        ListNBT invitedList = new ListNBT();
        this.invited.forEach(uuid -> invitedList.add((Object)StringNBT.func_229705_a_((String)uuid.toString())));
        compound.func_218657_a("Invited", (INBT)invitedList);
        if (this.owner != null) {
            compound.func_74778_a("Owner", this.owner.toString());
        }
        return compound;
    }

    public void deserializeNBT(CompoundNBT compound) {
        this.teamUUID = UUID.fromString(compound.func_74779_i("UUID"));
        this.name = compound.func_74764_b("Name") ? compound.func_74779_i("Name") : this.teamUUID.toString();
        this.data = compound.func_74775_l("Data");
        this.members = new HashSet<UUID>();
        this.invited = new HashSet<UUID>();
        this.owner = compound.func_74764_b("Owner") ? UUID.fromString(compound.func_74779_i("Owner")) : null;
        ListNBT list = compound.func_150295_c("Members", 8);
        for (int i = 0; i < list.size(); ++i) {
            this.members.add(UUID.fromString(list.func_150307_f(i)));
        }
        compound.func_150295_c("Invited", 8).forEach(nbt -> this.invited.add(UUID.fromString(nbt.func_150285_a_())));
        if (this.owner == null) {
            this.owner = this.members.stream().findFirst().orElse(null);
            MinecraftForge.EVENT_BUS.post((Event)new TeamChangedOwnerEvent(this.teamUUID, this.owner));
        }
    }
}

