/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.husbandry.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.ResourceLocation;
import uk.joshiejack.husbandry.item.HusbandryItems;
import uk.joshiejack.husbandry.tileentity.HusbandryTileEntities;
import uk.joshiejack.penguinlib.data.TimeUnitRegistry;
import uk.joshiejack.penguinlib.data.database.CSVUtils;
import uk.joshiejack.penguinlib.data.generators.AbstractDatabaseProvider;
import uk.joshiejack.penguinlib.data.generators.builders.Trade;
import uk.joshiejack.penguinlib.data.generators.builders.TradeBuilder;

public class HusbandryDatabase
extends AbstractDatabaseProvider {
    public HusbandryDatabase(DataGenerator gen) {
        super(gen, "husbandry");
    }

    protected void addDatabaseEntries() {
        this.addTimeUnit("require_food_max_days", 3L);
        this.addTimeUnitForMachine((TileEntityType)HusbandryTileEntities.INCUBATOR.get(), TimeUnitRegistry.Defaults.WEEK.getValue());
        new Trade(VillagerProfession.field_221163_m, 1, (IItemProvider)HusbandryItems.GENERIC_TREAT.get()).setOutputAmount(5).build((AbstractDatabaseProvider)this);
        new Trade(VillagerProfession.field_221163_m, 2, (IItemProvider)HusbandryItems.CAT_TREAT.get()).setOutputAmount(3).setInputAmount(2).build((AbstractDatabaseProvider)this);
        new Trade(VillagerProfession.field_221163_m, 2, (IItemProvider)HusbandryItems.CHICKEN_TREAT.get()).setOutputAmount(3).setInputAmount(2).build((AbstractDatabaseProvider)this);
        new Trade(VillagerProfession.field_221163_m, 2, (IItemProvider)HusbandryItems.COW_TREAT.get()).setOutputAmount(3).setInputAmount(2).build((AbstractDatabaseProvider)this);
        new Trade(VillagerProfession.field_221163_m, 2, (IItemProvider)HusbandryItems.DOG_TREAT.get()).setOutputAmount(3).setInputAmount(2).build((AbstractDatabaseProvider)this);
        new Trade(VillagerProfession.field_221163_m, 2, (IItemProvider)HusbandryItems.HORSE_TREAT.get()).setOutputAmount(3).setInputAmount(2).build((AbstractDatabaseProvider)this);
        new Trade(VillagerProfession.field_221163_m, 2, (IItemProvider)HusbandryItems.PIG_TREAT.get()).setOutputAmount(3).setInputAmount(2).build((AbstractDatabaseProvider)this);
        new Trade(VillagerProfession.field_221163_m, 2, (IItemProvider)HusbandryItems.RABBIT_TREAT.get()).setOutputAmount(3).setInputAmount(2).build((AbstractDatabaseProvider)this);
        new Trade(VillagerProfession.field_221163_m, 2, (IItemProvider)HusbandryItems.SHEEP_TREAT.get()).setOutputAmount(3).setInputAmount(2).build((AbstractDatabaseProvider)this);
        new TradeBuilder(VillagerProfession.field_221163_m, 2, (IItemProvider)HusbandryItems.PARROT_TREAT.get()).setOutputAmount(3).setInputAmount(2).build((AbstractDatabaseProvider)this);
        new TradeBuilder(VillagerProfession.field_221163_m, 2, (IItemProvider)HusbandryItems.LLAMA_TREAT.get()).setOutputAmount(3).setInputAmount(2).build((AbstractDatabaseProvider)this);
        MobType.createMammal("cow").withLifespan(12, 20).withTreat((Item)HusbandryItems.COW_TREAT.get()).levelUpWith(7, 24).withGestationPeriod(9).withMaturityAt(14).withProducts(1, "milk", Items.field_151117_aB).assign(EntityType.field_200796_j).withTraits("diurnal", "eats_grass", "cleanable", "bucketable", "more_product").build(this);
        MobType.createBird("chicken").withLifespan(3, 10).withTreat((Item)HusbandryItems.CHICKEN_TREAT.get()).levelUpWith(5, 26).withGestationPeriod(3).withMaturityAt(3).withProducts(1, "chicken_egg", Items.field_151110_aK).assign(EntityType.field_200795_i).withTraits("aquaphobic", "diurnal", "lays_egg", "more_product").build(this);
        MobType.createMammal("pig").withLifespan(6, 10).withTreat((Item)HusbandryItems.PIG_TREAT.get()).levelUpWith(20, 10).withGestationPeriod(4).withMaturityAt(4).withProducts(1, "truffle", (Item)HusbandryItems.TRUFFLE_BLOCK.get()).assign(EntityType.field_200784_X).withTraits("aquaphobic", "diurnal", "eats_slop", "cleanable", "pettable", "finds_product", "more_product_chance").build(this);
        MobType.createMammal("sheep").withLifespan(8, 12).withTreat((Item)HusbandryItems.SHEEP_TREAT.get()).levelUpWith(2, 29).withGestationPeriod(5).withMaturityAt(4).withProducts(7, "wool", Items.field_221603_aE).assign(EntityType.field_200737_ac).withTraits("diurnal", "eats_grass", "cleanable", "shearable", "faster_product_reset").build(this);
        MobType.createMammal("horse").withLifespan(25, 30).withTreat((Item)HusbandryItems.HORSE_TREAT.get()).levelUpWith(10, 22).withGestationPeriod(24).withMaturityAt(12).assign(EntityType.field_200762_B).withTraits("aquaphobic", "diurnal", "eats_grass", "cleanable", "pet").build(this);
        MobType.createMammal("llama").withLifespan(15, 25).withTreat((Item)HusbandryItems.LLAMA_TREAT.get()).levelUpWith(7, 24).withGestationPeriod(11).withMaturityAt(10).assign(EntityType.field_200769_I).withTraits("diurnal", "eats_grass", "cleanable", "pet").build(this);
        MobType.createSmallMammal("rabbit").withLifespan(8, 12).withTreat((Item)HusbandryItems.RABBIT_TREAT.get()).levelUpWith(14, 14).withGestationPeriod(4).withMaturityAt(3).withProducts(4, "rabbit_foot", Items.field_179556_br).withTraits("eats_rabbit_food", "drops_product", "more_product_chance").assign(EntityType.field_200736_ab).build(this);
        MobType.createSmallMammal("cat").withLifespan(10, 20).withTreat((Item)HusbandryItems.CAT_TREAT.get()).levelUpWith(3, 24).withGestationPeriod(5).withMaturityAt(7).assign(EntityType.field_220360_g).withTraits("aquaphobic", "eats_cat_food", "pet").build(this);
        MobType.createMammal("dog").withLifespan(10, 13).withTreat((Item)HusbandryItems.DOG_TREAT.get()).levelUpWith(24, 3).withGestationPeriod(5).withMaturityAt(7).assign(EntityType.field_200724_aC).withTraits("diurnal", "eats_dog_food", "cleanable", "pet").build(this);
        MobType.createMammal("donkey").withLifespan(25, 30).withTreat((Item)HusbandryItems.HORSE_TREAT.get()).levelUpWith(22, 11).withGestationPeriod(24).withMaturityAt(12).assign(EntityType.field_200798_l).assign(EntityType.field_200779_S).withTraits("aquaphobic", "diurnal", "eats_grass", "cleanable", "pet").build(this);
        MobType.createBird("parrot").withLifespan(25, 50).withTreat((Item)HusbandryItems.PARROT_TREAT.get()).levelUpWith(3, 24).withGestationPeriod(4).withMaturityAt(36).assign(EntityType.field_200783_W).withTraits("aquaphobic", "diurnal", "pet").build(this);
        MobType.createMammal("mooshroom").withLifespan(13, 21).withTreat((Item)HusbandryItems.COW_TREAT.get()).levelUpWith(24, 7).withGestationPeriod(11).withMaturityAt(21).withProducts(1, "mushroom_stew", Items.field_151009_A).assign(EntityType.field_200780_T).withTraits("diurnal", "eats_grass", "cleanable", "bowlable", "more_product").build(this);
    }

    private static class MobType {
        public static final ResourceLocation NO_PRODUCTS = new ResourceLocation("husbandry", "none");
        private final String name;
        private RangedInteger lifespan = new RangedInteger(5, 12);
        private Item treat = (Item)HusbandryItems.GENERIC_TREAT.get();
        private int generic = 10;
        private int type = 10;
        private int gestation = 9;
        private int maturity = 10;
        private int productsFrequency = 0;
        private ResourceLocation productTable = NO_PRODUCTS;
        private Item productsIcon = Items.field_190931_a;
        private final List<EntityType<?>> entities = new ArrayList();
        private final List<String> traits = new ArrayList<String>();

        private MobType(String name) {
            this.name = name;
        }

        public static MobType createBird(String name) {
            return new MobType(name).withTraits("mortal", "eats_bird_feed", "carriable", "treatable", "astraphobic");
        }

        public static MobType createSmallMammal(String name) {
            return new MobType(name).withTraits("mortal", "mammal", "carriable", "treatable", "astraphobic");
        }

        public static MobType createMammal(String name) {
            return new MobType(name).withTraits("mortal", "mammal", "pettable", "treatable", "astraphobic");
        }

        public MobType withTraits(String ... traits) {
            this.traits.addAll(Arrays.asList(traits));
            return this;
        }

        public MobType assign(EntityType<?> entity) {
            this.entities.add(entity);
            return this;
        }

        public MobType withLifespan(int min, int max) {
            this.lifespan = new RangedInteger(min, max);
            return this;
        }

        public MobType withTreat(Item item) {
            this.treat = item;
            return this;
        }

        public MobType levelUpWith(int generic, int type) {
            this.generic = generic;
            this.type = type;
            return this;
        }

        public MobType withGestationPeriod(int gestation) {
            this.gestation = gestation;
            return this;
        }

        public MobType withMaturityAt(int maturity) {
            this.maturity = maturity;
            return this;
        }

        public MobType withProducts(int productFrequency, String table, Item icon) {
            this.productsFrequency = productFrequency;
            this.productTable = new ResourceLocation("husbandry", "entities/products/" + table);
            this.productsIcon = icon;
            return this;
        }

        public void build(HusbandryDatabase database) {
            database.addEntry("mob_species", "Name,Min Age,Max Age,Treat Item,Generic Treats,Species Treats,Days to Birth,Days to Maturity,Product Frequency,Products Loot Table,Product Icon", CSVUtils.join((Object[])new Comparable[]{this.name, Integer.valueOf(this.lifespan.func_233016_a_()), Integer.valueOf(this.lifespan.func_233019_b_()), this.treat.getRegistryName(), Integer.valueOf(this.generic), Integer.valueOf(this.type), Integer.valueOf(this.gestation), Integer.valueOf(this.maturity), Integer.valueOf(this.productsFrequency), this.productTable == NO_PRODUCTS ? "none" : this.productTable.toString(), this.productsIcon.getRegistryName()}));
            this.entities.forEach(entity -> database.addEntry("mob_entities", "Entity,Species", CSVUtils.join((Object[])new String[]{Objects.requireNonNull(entity.getRegistryName()).toString(), this.name})));
            this.traits.forEach(trait -> database.addEntry("mob_traits", "Species,Trait", CSVUtils.join((Object[])new String[]{this.name, trait})));
        }
    }
}

