/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.husbandry.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.Level;
import uk.joshiejack.husbandry.Husbandry;
import uk.joshiejack.husbandry.api.trait.IMobTrait;
import uk.joshiejack.husbandry.entity.stats.MobStats;
import uk.joshiejack.husbandry.entity.stats.Products;
import uk.joshiejack.husbandry.entity.stats.Species;
import uk.joshiejack.husbandry.network.RequestDataPacket;
import uk.joshiejack.penguinlib.events.DatabaseLoadedEvent;
import uk.joshiejack.penguinlib.network.PenguinNetwork;
import uk.joshiejack.penguinlib.network.PenguinPacket;
import uk.joshiejack.penguinlib.util.icon.Icon;
import uk.joshiejack.penguinlib.util.icon.ItemIcon;

@Mod.EventBusSubscriber(modid="husbandry")
public class MobDataLoader {
    public static final Map<String, IMobTrait> TRAITS = Maps.newHashMap();

    @SubscribeEvent
    public static void onDatabaseLoaded(DatabaseLoadedEvent event) {
        HashMap types = Maps.newHashMap();
        event.table("mob_species").rows().forEach(row -> {
            String name = (String)row.get("name");
            ArrayList traits = Lists.newArrayList();
            event.table("mob_traits").where("species=" + name).forEach(trait -> traits.add(TRAITS.get(trait.get("trait").toString())));
            Products products = row.get("products loot table").equals("none") ? Products.NONE : new Products((Integer)row.get("product frequency"), row.getRL("products loot table"), (Icon)new ItemIcon(row.item("product icon")));
            Species type = new Species((Integer)row.get("min age"), (Integer)row.get("max age"), row.item("treat item"), (Integer)row.get("generic treats"), (Integer)row.get("species treats"), (Integer)row.get("days to birth"), (Integer)row.get("days to maturity"), products, traits);
            types.put(name, type);
            Husbandry.LOGGER.log(Level.INFO, "Registered a new mob species: " + name);
        });
        event.table("mob_entities").rows().forEach(entities -> {
            String name = (String)entities.get("species");
            EntityType type = entities.entity();
            if (type != null) {
                Species.TYPES.put((EntityType<?>)type, (Species)types.get(name));
                Husbandry.LOGGER.log(Level.INFO, "Registered the entity " + entities.get("entity") + " as a " + name);
            }
        });
    }

    @SubscribeEvent
    public static void onCapabilityLoading(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof MobEntity && Species.TYPES.containsKey(entity.func_200600_R())) {
            event.addCapability(new ResourceLocation("husbandry", "stats"), new MobStats<MobEntity>((MobEntity)entity, Species.TYPES.get(entity.func_200600_R())));
        }
    }

    @SubscribeEvent
    public static void onEntityJoinedWorld(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            PenguinNetwork.sendToServer((PenguinPacket)new RequestDataPacket(event.getEntity().func_145782_y()));
        }
    }
}

