/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.husbandry.entity.traits.happiness;

import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import uk.joshiejack.husbandry.Husbandry;
import uk.joshiejack.husbandry.api.IMobStats;
import uk.joshiejack.husbandry.api.trait.IDataTrait;
import uk.joshiejack.husbandry.api.trait.IIconTrait;
import uk.joshiejack.husbandry.api.trait.IInteractiveTrait;
import uk.joshiejack.husbandry.api.trait.INewDayTrait;
import uk.joshiejack.husbandry.item.HusbandryItems;
import uk.joshiejack.husbandry.network.SetCleanedStatusPacket;
import uk.joshiejack.penguinlib.network.PenguinNetwork;
import uk.joshiejack.penguinlib.network.PenguinPacket;
import uk.joshiejack.penguinlib.util.helpers.generic.MathsHelper;
import uk.joshiejack.penguinlib.util.icon.Icon;
import uk.joshiejack.penguinlib.util.icon.ItemIcon;

public class CleanableTrait
implements IDataTrait,
IInteractiveTrait,
INewDayTrait,
IIconTrait {
    private static final Lazy<Icon> ICON = Lazy.of(() -> new ItemIcon(new ItemStack((IItemProvider)HusbandryItems.BRUSH.get())));
    private int cleanliness;
    private boolean cleaned;

    @Override
    public void onNewDay(IMobStats<?> stats) {
        this.setCleaned(stats, false);
        this.cleanliness = MathsHelper.constrainToRangeInt((int)(this.cleanliness - 10), (int)-100, (int)100);
        if (this.cleanliness <= 0) {
            stats.decreaseHappiness((Integer)Husbandry.HusbandryConfig.dirtyHappinessLoss.get());
        }
    }

    @Override
    public Icon getIcon(IMobStats<?> stats) {
        return this.cleaned ? (Icon)ICON.get() : ((Icon)ICON.get()).shadowed();
    }

    @Override
    public boolean onRightClick(IMobStats<?> stats, PlayerEntity player, Hand hand) {
        if (player.func_184586_b(hand).func_77973_b() == HusbandryItems.BRUSH.get() && this.clean(stats)) {
            World world = player.field_70170_p;
            Object entity = stats.getEntity();
            if (world.field_72995_K) {
                if (world.func_72820_D() % 3L == 0L) {
                    player.func_184609_a(hand);
                }
                int j = 0;
                while ((double)j < 30.0) {
                    double x = ((MobEntity)entity).field_70169_q - 0.5 + (double)world.field_73012_v.nextFloat();
                    double y = ((MobEntity)entity).field_70167_r - 0.5 + (double)world.field_73012_v.nextFloat();
                    double z = ((MobEntity)entity).field_70166_s - 0.5 + (double)world.field_73012_v.nextFloat();
                    world.func_195594_a((IParticleData)ParticleTypes.field_197614_g, x, 1.0 + y, z, 0.0, 0.0, 0.0);
                    ++j;
                }
            }
            world.func_184148_a(player, player.field_70169_q, player.field_70167_r, player.field_70166_s, (SoundEvent)Husbandry.HusbandrySounds.BRUSH.get(), SoundCategory.PLAYERS, 1.5f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
            return true;
        }
        return false;
    }

    private boolean clean(IMobStats<?> stats) {
        if (!this.cleaned) {
            ++this.cleanliness;
            if (this.cleanliness == 50) {
                this.setCleaned(stats, true);
            }
            return true;
        }
        return false;
    }

    public void setCleaned(IMobStats<?> stats, boolean cleaned) {
        Object entity = stats.getEntity();
        if (((MobEntity)entity).field_70170_p.field_72995_K) {
            this.cleaned = cleaned;
        } else {
            this.cleaned = cleaned;
            if (cleaned) {
                stats.increaseHappiness((Integer)Husbandry.HusbandryConfig.cleanedGain.get());
            }
            PenguinNetwork.sendToNearby((PenguinPacket)new SetCleanedStatusPacket(entity.func_145782_y(), cleaned), entity);
        }
    }

    @Override
    public void load(CompoundNBT nbt) {
        this.cleanliness = nbt.func_74762_e("Cleanliness");
        this.cleaned = nbt.func_74767_n("Cleaned");
    }

    @Override
    public void save(CompoundNBT tag) {
        tag.func_74768_a("Cleanliness", this.cleanliness);
        tag.func_74757_a("Cleaned", this.cleaned);
    }
}

