/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.husbandry.entity.traits.happiness;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import uk.joshiejack.husbandry.Husbandry;
import uk.joshiejack.husbandry.api.IMobStats;
import uk.joshiejack.husbandry.api.trait.IDataTrait;
import uk.joshiejack.husbandry.api.trait.IIconTrait;
import uk.joshiejack.husbandry.api.trait.IInteractiveTrait;
import uk.joshiejack.husbandry.api.trait.INewDayTrait;
import uk.joshiejack.husbandry.item.HusbandryItems;
import uk.joshiejack.penguinlib.util.icon.Icon;
import uk.joshiejack.penguinlib.util.icon.ItemIcon;

public class TreatableTrait
implements IDataTrait,
IInteractiveTrait,
INewDayTrait,
IIconTrait {
    public static final ITag.INamedTag<Item> TREATS = ItemTags.createOptional((ResourceLocation)new ResourceLocation("husbandry", "treat"));
    private boolean treated;
    private int genericTreatsGiven;
    private int speciesTreatsGiven;
    private boolean annoyed;
    private Icon icon;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getIcon(IMobStats<?> stats) {
        if (this.icon == null) {
            this.icon = new ItemIcon(stats.getSpecies().getTreat());
        }
        return this.treated ? this.icon : this.icon.shadowed();
    }

    @Override
    public void onNewDay(IMobStats<?> stats) {
        if (stats.getHappinessModifier() > 1 && this.genericTreatsGiven >= stats.getSpecies().getGenericTreats() && this.speciesTreatsGiven >= stats.getSpecies().getSpeciesTreats()) {
            this.genericTreatsGiven -= stats.getSpecies().getGenericTreats();
            this.speciesTreatsGiven -= stats.getSpecies().getSpeciesTreats();
            stats.setHappinessModifier(stats.getHappinessModifier() - 1);
        }
        this.treated = false;
        this.annoyed = false;
    }

    @Override
    public boolean onRightClick(IMobStats<?> stats, PlayerEntity player, Hand hand) {
        boolean generic;
        ItemStack held = player.func_184586_b(hand);
        if (!TREATS.func_230235_a_((Object)held.func_77973_b())) {
            return false;
        }
        boolean bl = generic = held.func_77973_b() == HusbandryItems.GENERIC_TREAT.get();
        if (!generic && stats.getSpecies().getTreat() != held.func_77973_b() && !this.annoyed) {
            this.annoyed = true;
            stats.decreaseHappiness((Integer)Husbandry.HusbandryConfig.wrongTreatLoss.get());
            held.func_190918_g(1);
            return true;
        }
        if (!this.treated) {
            if (generic) {
                ++this.genericTreatsGiven;
            } else {
                ++this.speciesTreatsGiven;
            }
            held.func_190918_g(1);
            stats.increaseHappiness(generic ? ((Integer)Husbandry.HusbandryConfig.typeTreatGain.get()).intValue() : ((Integer)Husbandry.HusbandryConfig.genericTreatGain.get()).intValue());
            this.treated = true;
            return true;
        }
        return false;
    }

    @Override
    public void load(CompoundNBT nbt) {
        this.treated = nbt.func_74767_n("Treated");
        this.genericTreatsGiven = nbt.func_74762_e("GenericTreats");
        this.speciesTreatsGiven = nbt.func_74762_e("TypeTreats");
        this.annoyed = nbt.func_74767_n("Annoyed");
    }

    @Override
    public void save(CompoundNBT nbt) {
        nbt.func_74757_a("Treated", this.treated);
        nbt.func_74757_a("Annoyed", this.annoyed);
        nbt.func_74768_a("GenericTreats", this.genericTreatsGiven);
        nbt.func_74768_a("TypeTreats", this.speciesTreatsGiven);
    }
}

