/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.husbandry.network;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import uk.joshiejack.husbandry.entity.stats.MobStats;
import uk.joshiejack.husbandry.entity.traits.TraitType;
import uk.joshiejack.husbandry.entity.traits.happiness.CleanableTrait;
import uk.joshiejack.penguinlib.network.PenguinPacket;
import uk.joshiejack.penguinlib.util.PenguinLoader;

@PenguinLoader.Packet(value=NetworkDirection.PLAY_TO_CLIENT)
public class SetCleanedStatusPacket
extends PenguinPacket {
    private int entityID;
    private boolean cleaned;

    public SetCleanedStatusPacket() {
    }

    public SetCleanedStatusPacket(int entityID, boolean cleaned) {
        this.entityID = entityID;
        this.cleaned = cleaned;
    }

    public void encode(PacketBuffer to) {
        to.writeInt(this.entityID);
        to.writeBoolean(this.cleaned);
    }

    public void decode(PacketBuffer from) {
        this.entityID = from.readInt();
        this.cleaned = from.readBoolean();
    }

    public void handle(PlayerEntity player) {
        MobStats<?> stats;
        Entity entity = player.field_70170_p.func_73045_a(this.entityID);
        if (entity != null && (stats = MobStats.getStats(entity)) != null) {
            stats.getTraits(TraitType.DATA).stream().filter(s -> s instanceof CleanableTrait).findFirst().ifPresent(t -> ((CleanableTrait)t).setCleaned(stats, this.cleaned));
        }
    }
}

