/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.husbandry.network;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import uk.joshiejack.penguinlib.network.PenguinPacket;
import uk.joshiejack.penguinlib.util.PenguinLoader;

@PenguinLoader.Packet(value=NetworkDirection.PLAY_TO_CLIENT)
public class SpawnHeartsPacket
extends PenguinPacket {
    private int entityID;
    private boolean positive;

    public SpawnHeartsPacket() {
    }

    public SpawnHeartsPacket(int entityID, boolean positive) {
        this.entityID = entityID;
        this.positive = positive;
    }

    public void encode(PacketBuffer to) {
        to.writeInt(this.entityID);
        to.writeBoolean(this.positive);
    }

    public void decode(PacketBuffer from) {
        this.entityID = from.readInt();
        this.positive = from.readBoolean();
    }

    public void handle(PlayerEntity player) {
        World world = player.field_70170_p;
        Entity entity = world.func_73045_a(this.entityID);
        if (entity != null) {
            BasicParticleType type = this.positive ? ParticleTypes.field_197633_z : ParticleTypes.field_197615_h;
            int times = this.positive ? 3 : 16;
            double offset = this.positive ? -0.125 : 0.0;
            for (int j = 0; j < times; ++j) {
                double x = entity.field_70169_q - 0.5 + (double)world.field_73012_v.nextFloat();
                double y = entity.field_70167_r - 0.5 + (double)world.field_73012_v.nextFloat();
                double z = entity.field_70166_s - 0.5 + (double)world.field_73012_v.nextFloat();
                world.func_195594_a((IParticleData)type, x, 1.0 + y + offset, z, 0.0, 0.0, 0.0);
            }
        }
    }
}

