/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.improvedmobs.ai;

import com.flemmli97.improvedmobs.config.Config;
import com.flemmli97.improvedmobs.utils.GeneralHelperMethods;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class BlockBreakGoal
extends Goal {
    protected final MobEntity living;
    private LivingEntity target;
    private BlockPos markedLoc;
    private BlockPos entityPos;
    private int digTimer;
    private int cooldown = Config.CommonConfig.breakerInitCooldown;
    private final List<BlockPos> breakAOE = new ArrayList<BlockPos>();
    private int breakIndex;
    private final int digHeight;

    public BlockBreakGoal(MobEntity living) {
        this.living = living;
        int digWidth = living.func_213311_cf() < 1.0f ? 0 : MathHelper.func_76123_f((float)living.func_213311_cf());
        for (int i = this.digHeight = (int)living.func_213302_cg() + 1; i >= 0; --i) {
            this.breakAOE.add(new BlockPos(0, i, 0));
        }
        for (int z = digWidth + 1; z >= -digWidth; --z) {
            for (int y = this.digHeight; y >= 0; --y) {
                for (int x = 0; x <= digWidth; ++x) {
                    if (z == 0) continue;
                    this.breakAOE.add(new BlockPos(x, y, z));
                    if (x == 0) continue;
                    this.breakAOE.add(new BlockPos(-x, y, z));
                }
            }
        }
    }

    public boolean func_75250_a() {
        this.target = this.living.func_70638_az();
        if (this.entityPos == null) {
            this.entityPos = this.living.func_233580_cy_();
            this.cooldown = Config.CommonConfig.breakerCooldown;
        }
        if (--this.cooldown <= 0) {
            if (!this.entityPos.equals((Object)this.living.func_233580_cy_())) {
                this.entityPos = null;
                this.cooldown = Config.CommonConfig.breakerCooldown;
                return false;
            }
            if (this.target != null && this.living.func_70068_e((Entity)this.target) > 1.0) {
                BlockPos blockPos = this.getDiggingLocation();
                if (blockPos == null) {
                    return false;
                }
                this.cooldown = Config.CommonConfig.breakerCooldown;
                this.markedLoc = blockPos;
                this.entityPos = this.living.func_233580_cy_();
                return true;
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.target != null && this.target.func_70089_S() && this.living.func_70089_S() && this.markedLoc != null && this.nearSameSpace(this.entityPos, this.living.func_233580_cy_()) && this.living.func_70068_e((Entity)this.target) > 1.0;
    }

    private boolean nearSameSpace(BlockPos pos1, BlockPos pos2) {
        return pos1 != null && pos2 != null && pos1.func_177958_n() == pos2.func_177958_n() && pos1.func_177952_p() == pos2.func_177952_p() && Math.abs(pos1.func_177956_o() - pos2.func_177956_o()) <= 1;
    }

    public void func_75251_c() {
        this.breakIndex = 0;
        if (this.markedLoc != null) {
            this.living.field_70170_p.func_175715_c(this.living.func_145782_y(), this.markedLoc, -1);
        }
        this.markedLoc = null;
    }

    public void func_75246_d() {
        if (this.markedLoc == null || this.living.field_70170_p.func_180495_p(this.markedLoc).func_196951_e((IBlockReader)this.living.field_70170_p, this.markedLoc).func_197766_b()) {
            this.digTimer = 0;
            return;
        }
        BlockState state = this.living.field_70170_p.func_180495_p(this.markedLoc);
        float str = GeneralHelperMethods.getBlockStrength(this.living, state, this.living.field_70170_p, this.markedLoc);
        float f = str = str == Float.POSITIVE_INFINITY ? 1.0f : str / (1.0f + str * 6.0f) * (float)(this.digTimer + 1);
        if (str >= 1.0f) {
            this.digTimer = 0;
            this.cooldown = (int)((double)this.cooldown * 0.5);
            ItemStack item = this.living.func_184614_ca();
            ItemStack itemOff = this.living.func_184592_cb();
            boolean canHarvest = GeneralHelperMethods.canHarvest(state, item) || GeneralHelperMethods.canHarvest(state, itemOff);
            this.living.field_70170_p.func_175655_b(this.markedLoc, canHarvest);
            this.markedLoc = null;
            if (!this.aboveTarget()) {
                this.living.func_70659_e(0.0f);
                this.living.func_70661_as().func_75499_g();
                this.living.func_70661_as().func_75484_a(this.living.func_70661_as().func_75494_a((Entity)this.target, 0), 1.0);
            }
        } else {
            ++this.digTimer;
            if (this.digTimer % 5 == 0) {
                SoundType sound = state.getSoundType((IWorldReader)this.living.field_70170_p, this.markedLoc, (Entity)this.living);
                this.living.field_70170_p.func_184133_a(null, this.markedLoc, Config.CommonConfig.useBlockBreakSound ? sound.func_185845_c() : SoundEvents.field_187679_dF, SoundCategory.BLOCKS, 2.0f, 0.5f);
                this.living.func_184609_a(Hand.MAIN_HAND);
                this.living.func_70671_ap().func_75650_a((double)this.markedLoc.func_177958_n(), (double)this.markedLoc.func_177956_o(), (double)this.markedLoc.func_177952_p(), 0.0f, 0.0f);
                this.living.field_70170_p.func_175715_c(this.living.func_145782_y(), this.markedLoc, (int)str * this.digTimer * 10);
            }
        }
    }

    public BlockPos getDiggingLocation() {
        BlockState state;
        ItemStack item = this.living.func_184614_ca();
        ItemStack itemOff = this.living.func_184592_cb();
        BlockPos pos = this.living.func_233580_cy_();
        if (this.living.func_70638_az() != null) {
            Vector3d target = this.living.func_70638_az().func_213303_ch();
            if (this.aboveTarget() && Math.abs(target.field_72450_a - (double)pos.func_177958_n()) <= 1.0 && Math.abs(target.field_72449_c - (double)pos.func_177952_p()) <= 1.0 && this.canBreak((LivingEntity)this.living, state = this.living.field_70170_p.func_180495_p(pos = this.living.func_233580_cy_().func_177977_b()), pos, item, itemOff)) {
                this.breakIndex = 0;
                return pos;
            }
        }
        Rotation rot = BlockBreakGoal.getDigDirection(this.living);
        BlockPos offset = this.breakAOE.get(this.breakIndex);
        state = this.living.field_70170_p.func_180495_p(pos = pos.func_177971_a((Vector3i)(offset = new BlockPos(offset.func_177958_n(), this.aboveTarget() ? -(offset.func_177956_o() - this.digHeight) : offset.func_177956_o(), offset.func_177952_p())).func_190942_a(rot)));
        if (this.canBreak((LivingEntity)this.living, state, pos, item, itemOff)) {
            this.breakIndex = 0;
            return pos;
        }
        ++this.breakIndex;
        if (this.breakIndex == this.breakAOE.size()) {
            this.breakIndex = 0;
        }
        return null;
    }

    private boolean canBreak(LivingEntity entity, BlockState state, BlockPos pos, ItemStack item, ItemStack itemOff) {
        return Config.CommonConfig.breakableBlocks.canBreak(state, pos, (IBlockReader)entity.field_70170_p, ISelectionContext.func_216374_a((Entity)entity)) && (GeneralHelperMethods.canHarvest(state, item) || GeneralHelperMethods.canHarvest(state, itemOff));
    }

    private boolean aboveTarget() {
        return this.target.func_226278_cu_() < this.living.func_226278_cu_() + 1.1;
    }

    public static Rotation getDigDirection(MobEntity mob) {
        Path path = mob.func_70661_as().func_75505_d();
        if (path != null) {
            PathPoint point;
            PathPoint pathPoint = point = path.func_75873_e() < path.func_75874_d() ? path.func_237225_h_() : null;
            if (point != null) {
                Vector3d dir = new Vector3d((double)point.field_75839_a + 0.5, mob.func_226278_cu_(), (double)point.field_75838_c + 0.5).func_178788_d(mob.func_213303_ch());
                if (Math.abs(dir.field_72450_a) < Math.abs(dir.field_72449_c)) {
                    if (dir.field_72449_c >= 0.0) {
                        return Rotation.NONE;
                    }
                    return Rotation.CLOCKWISE_180;
                }
                if (dir.field_72450_a > 0.0) {
                    return Rotation.COUNTERCLOCKWISE_90;
                }
                return Rotation.CLOCKWISE_90;
            }
        }
        switch (mob.func_174811_aO()) {
            case SOUTH: {
                return Rotation.CLOCKWISE_180;
            }
            case EAST: {
                return Rotation.CLOCKWISE_90;
            }
            case WEST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }
}

