/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.improvedmobs.ai;

import com.flemmli97.improvedmobs.mixin.MobEntityMixin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public class FlyRidingGoal
extends Goal {
    public static final ResourceLocation EMPTY = new ResourceLocation("improvedmobs", "empty");
    protected final MobEntity living;
    private int wait = 0;
    private int pathCheckWait;
    private int flyDelay;
    private boolean start;
    private PathNavigator flyer;

    public FlyRidingGoal(MobEntity living) {
        this.living = living;
        this.flyer = new FlyingPathNavigator(living, living.field_70170_p){

            public boolean func_188555_b(BlockPos blockPos) {
                return true;
            }
        };
    }

    public boolean func_75250_a() {
        if (this.living.func_184187_bx() instanceof ParrotEntity) {
            return true;
        }
        if (!this.living.func_184218_aH() && this.living.func_70638_az() != null && this.living.func_70638_az().func_70089_S()) {
            if (this.wait >= 80 && --this.pathCheckWait <= 0) {
                if (this.checkFlying()) {
                    this.wait = 0;
                    return true;
                }
                this.pathCheckWait = 25;
            }
            ++this.wait;
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.living.func_184187_bx() instanceof ParrotEntity) {
            this.wait = this.living.func_70638_az() == null ? ++this.wait : 0;
            return this.wait < 100;
        }
        return false;
    }

    public void func_75251_c() {
        this.living.func_184210_p();
        this.living.func_195064_c(new EffectInstance(Effects.field_204839_B, 200, 1));
        this.wait = 0;
    }

    public void func_75249_e() {
        this.start = true;
    }

    public void func_75246_d() {
        Entity entity;
        if (this.start) {
            if (!this.living.func_184218_aH()) {
                ParrotEntity boat = (ParrotEntity)EntityType.field_200783_W.func_200721_a(this.living.field_70170_p);
                BlockPos pos = this.living.func_233580_cy_();
                boat.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, this.living.field_70177_z, this.living.field_70125_A);
                if (this.living.field_70170_p.func_226669_j_((Entity)boat)) {
                    ((MobEntityMixin)boat).setDeathLootTable(EMPTY);
                    boat.getPersistentData().func_74757_a("improvedmobs:water_riding", true);
                    this.living.field_70170_p.func_217376_c((Entity)boat);
                    this.living.func_184220_m((Entity)boat);
                    this.flyDelay = 0;
                }
            }
            this.start = false;
        }
        if (!((entity = this.living.func_184187_bx()) instanceof ParrotEntity) || !entity.func_70089_S()) {
            return;
        }
        if (++this.flyDelay >= 40 && this.isOnLand(entity)) {
            this.living.func_184210_p();
        }
    }

    private boolean checkFlying() {
        Path path = this.living.func_70661_as().func_75505_d();
        if (path == null || path.func_75879_b() && !path.func_224771_h()) {
            Path flyer = this.flyer.func_75494_a((Entity)this.living.func_70638_az(), 1);
            double dist = path == null ? (double)this.living.func_233580_cy_().func_218139_n((Vector3i)this.living.func_70638_az().func_233580_cy_()) : (double)path.func_224769_l();
            return flyer != null && (flyer.func_224771_h() || (double)flyer.func_224769_l() < dist);
        }
        return false;
    }

    private boolean isOnLand(Entity riding) {
        if (this.living.func_70661_as().func_75500_f() && riding.field_70170_p.func_180495_p(riding.func_233580_cy_().func_177977_b()).func_185904_a().func_76220_a()) {
            return true;
        }
        if (this.living.func_70638_az() != null && this.living.func_70638_az().func_70068_e((Entity)this.living) < 1.0) {
            return riding.field_70170_p.func_180495_p(riding.func_233580_cy_().func_177977_b()).func_185904_a().func_76220_a();
        }
        return false;
    }
}

