/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.improvedmobs.ai;

import com.flemmli97.improvedmobs.ImprovedMobs;
import com.flemmli97.improvedmobs.capability.ITileOpened;
import com.flemmli97.improvedmobs.capability.TileCapProvider;
import java.util.Optional;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;

public class StealGoal
extends MoveToBlockGoal {
    private final CreatureEntity entity;
    private int stealDelay;

    public StealGoal(CreatureEntity entity) {
        super(entity, 1.0, 9);
        this.entity = entity;
    }

    public boolean func_75250_a() {
        return super.func_75250_a() && this.entity.func_70638_az() == null;
    }

    public void func_75246_d() {
        super.func_75246_d();
        this.stealDelay = Math.max(0, --this.stealDelay);
        TileEntity tile = this.entity.field_70170_p.func_175625_s(this.field_179494_b);
        if (tile instanceof IInventory && this.stealDelay == 0 && this.entity.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.field_179494_b)) < 5.0 && this.canSee()) {
            IInventory inv = (IInventory)tile;
            ItemStack drop = this.randomStack(inv);
            this.entity.field_70170_p.func_184133_a(null, this.entity.func_233580_cy_(), SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.3f, 1.0f);
            this.entity.func_184609_a(Hand.MAIN_HAND);
            ItemEntity item = new ItemEntity(this.entity.field_70170_p, this.entity.func_226277_ct_(), this.entity.func_226278_cu_(), this.entity.func_226281_cx_(), drop);
            this.entity.field_70170_p.func_217376_c((Entity)item);
            this.stealDelay = 150 + this.entity.func_70681_au().nextInt(45);
        }
    }

    private boolean canSee() {
        Vector3d block;
        Vector3d eyes = this.entity.func_174824_e(1.0f);
        BlockRayTraceResult res = this.entity.field_70170_p.func_217299_a(new RayTraceContext(eyes, block = Vector3d.func_237489_a_((Vector3i)this.field_179494_b), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this.entity));
        return res.func_216346_c() == RayTraceResult.Type.BLOCK && res.func_216350_a().equals((Object)this.field_179494_b);
    }

    private ItemStack randomStack(IInventory inv) {
        try {
            if (!inv.func_191420_l()) {
                ItemStack drop = inv.func_70298_a(this.entity.func_70681_au().nextInt(inv.func_70302_i_()), 1);
                for (int tries = 0; drop.func_190926_b() && tries < 10; ++tries) {
                    drop = inv.func_70298_a(this.entity.func_70681_au().nextInt(inv.func_70302_i_()), 1);
                }
                return drop;
            }
            return ItemStack.field_190927_a;
        }
        catch (Exception e) {
            ImprovedMobs.logger.error("#getSizeInventory and actual size of the inventory (" + inv + ") is not the same.");
            return ItemStack.field_190927_a;
        }
    }

    protected boolean func_179488_a(IWorldReader world, BlockPos pos) {
        Optional cap;
        TileEntity tile = world.func_175625_s(pos);
        boolean opened = false;
        if (tile instanceof IInventory && (cap = tile.getCapability(TileCapProvider.OpenedCap, null).resolve()).isPresent()) {
            opened = ((ITileOpened)cap.get()).playerOpened();
        }
        return opened && !((IInventory)tile).func_191420_l();
    }
}

