/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.improvedmobs.config;

import com.flemmli97.improvedmobs.ImprovedMobs;
import com.flemmli97.improvedmobs.config.Config;
import com.flemmli97.tenshilib.api.config.IConfigListValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.registries.ForgeRegistries;

public class BreakableBlocks
implements IConfigListValue<BreakableBlocks> {
    private final Set<String> blocks = new HashSet<String>();
    private List<String> configString = new ArrayList<String>();
    private final Set<ITag<Block>> tags = new HashSet<ITag<Block>>();
    private boolean initialized;

    public boolean canBreak(BlockState state, BlockPos pos, IBlockReader getter, ISelectionContext forEntity) {
        if (!this.initialized) {
            this.initialize();
        }
        if (state.func_215685_b(getter, pos, forEntity).func_197766_b()) {
            return false;
        }
        if (!Config.CommonConfig.breakTileEntities && state.func_177230_c().hasTileEntity(state)) {
            return false;
        }
        if (Config.CommonConfig.breakingAsBlacklist) {
            return this.tags.stream().noneMatch(arg_0 -> ((Block)state.func_177230_c()).func_203417_a(arg_0)) && !this.blocks.contains(state.func_177230_c().getRegistryName().toString());
        }
        return this.tags.stream().anyMatch(arg_0 -> ((Block)state.func_177230_c()).func_203417_a(arg_0)) || this.blocks.contains(state.func_177230_c().getRegistryName().toString());
    }

    public BreakableBlocks readFromString(List<String> arr) {
        this.blocks.clear();
        this.configString = arr;
        this.initialized = false;
        return this;
    }

    private void initialize() {
        this.initialized = true;
        HashSet<String> blackList = new HashSet<String>();
        HashSet<ITag<Block>> blackListTags = new HashSet<ITag<Block>>();
        for (String s : this.configString) {
            if (s.startsWith("!")) {
                BreakableBlocks.addBlocks(s.substring(1), blackList, blackListTags);
                continue;
            }
            BreakableBlocks.addBlocks(s, this.blocks, this.tags);
        }
        this.blocks.removeAll(blackList);
        this.tags.removeAll(blackListTags);
    }

    private static void addBlocks(String s, Set<String> list, Set<ITag<Block>> tags) {
        block8: {
            block6: {
                block7: {
                    if (!s.contains(":")) break block6;
                    ITag tag = BlockTags.func_199896_a().func_199910_a(new ResourceLocation(s));
                    if (tag == null) break block7;
                    tags.add((ITag<Block>)tag);
                    break block8;
                }
                if (ForgeRegistries.BLOCKS.getValue(new ResourceLocation(s)) == Blocks.field_150350_a) break block8;
                list.add(s);
                break block8;
            }
            Class<?> clss = null;
            try {
                clss = Class.forName("net.minecraft.block." + s);
            }
            catch (ClassNotFoundException e) {
                try {
                    clss = Class.forName(s);
                }
                catch (ClassNotFoundException e1) {
                    ImprovedMobs.logger.error("Couldn't find class for " + s);
                }
            }
            if (clss != null) {
                for (Block block : ForgeRegistries.BLOCKS) {
                    if (!clss.isInstance(block)) continue;
                    list.add(block.getRegistryName().toString());
                }
            }
        }
    }

    public List<String> writeToString() {
        return this.configString;
    }

    public static String use() {
        return "Usage: <registry name;classname;tag> put \"!\" infront to exclude blocks";
    }
}

