/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.improvedmobs.config;

import com.flemmli97.improvedmobs.ImprovedMobs;
import com.flemmli97.improvedmobs.config.Config;
import com.flemmli97.tenshilib.api.config.IConfigListValue;
import com.flemmli97.tenshilib.common.utils.ArrayUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityModifyFlagConfig
implements IConfigListValue<EntityModifyFlagConfig> {
    private final Map<String, EnumSet<Flags>> map = new HashMap<String, EnumSet<Flags>>();

    public void initDefault(World world) {
        this.map.clear();
        for (EntityType entry : ForgeRegistries.ENTITIES) {
            try {
                Entity e = entry.func_200721_a(world);
                if (!(e instanceof MobEntity) || e instanceof MonsterEntity || e instanceof GhastEntity || e instanceof PhantomEntity || e instanceof SlimeEntity || e instanceof ShulkerEntity) continue;
                this.map.put(entry.getRegistryName().toString(), EnumSet.of(Flags.ALL));
            }
            catch (Exception e) {
                ImprovedMobs.logger.error("Error during default entity config for EntityType {}, skipping this type. Cause: {}", (Object)entry.getRegistryName(), (Object)e.getMessage());
            }
        }
    }

    public boolean hasFlag(MobEntity living, Flags flag, boolean reverse) {
        ResourceLocation res = living.func_200600_R().getRegistryName();
        if (res == null) {
            return true;
        }
        if (Config.CommonConfig.flagBlacklist.contains(flag.toString())) {
            return true;
        }
        EnumSet<Flags> set = this.map.get(res.toString());
        if (set == null) {
            set = this.map.get(res.func_110624_b());
        }
        if (set != null) {
            return reverse ^ set.contains((Object)Flags.REVERSE) ^ (set.contains((Object)Flags.ALL) || set.contains((Object)flag));
        }
        return reverse;
    }

    public EntityModifyFlagConfig readFromString(List<String> s) {
        this.map.clear();
        for (String val : s) {
            EnumSet<Flags> set;
            String[] subs = val.split("\\|");
            if (subs.length == 1) {
                set = EnumSet.of(Flags.ALL);
            } else {
                set = EnumSet.noneOf(Flags.class);
                for (int i = 1; i < subs.length; ++i) {
                    set.add(Flags.valueOf(subs[i].trim()));
                }
            }
            this.map.put(subs[0].trim(), set);
        }
        return this;
    }

    public List<String> writeToString() {
        ArrayList<String> s = new ArrayList<String>();
        for (String key : this.map.keySet()) {
            StringBuilder val = new StringBuilder(key);
            for (Flags f : this.map.get(key)) {
                if (f == Flags.ALL) continue;
                val.append("|").append(f.name());
            }
            s.add(val.toString());
        }
        return s;
    }

    public static String use() {
        CharSequence[] str = new String[]{"<entity registry name> followed by any of:", "[" + ArrayUtils.arrayToString((Object[])Flags.values()) + "].", "Leave empty to apply them all and REVERSE to reverse all flags. Some flags do nothing for certain mobs!", "example: minecraft:sheep|REVERSE|ATTRIBUTES will add sheep to attributes modification (since default is a blacklist)", "or minecraft:sheep|ATTRIBUTES will add sheep to everything except attributes"};
        return String.join((CharSequence)"\n", str);
    }

    public static enum Flags {
        ALL,
        ATTRIBUTES,
        ARMOR,
        HELDITEMS,
        BLOCKBREAK,
        USEITEM,
        LADDER,
        STEAL,
        GUARDIAN,
        PARROT,
        TARGETVILLAGER,
        REVERSE;

    }
}

