/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.improvedmobs.config;

import com.flemmli97.improvedmobs.ImprovedMobs;
import com.flemmli97.improvedmobs.config.Config;
import com.flemmli97.improvedmobs.utils.ItemAI;
import com.flemmli97.improvedmobs.utils.ItemAITasks;
import com.flemmli97.tenshilib.api.config.ExtendedItemStackWrapper;
import com.flemmli97.tenshilib.common.utils.ItemUtils;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.MobEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.PotionItem;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public class EquipmentList {
    private static final Map<EquipmentSlotType, WeightedItemstackList> equips = new HashMap<EquipmentSlotType, WeightedItemstackList>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static Field techGunDmg;
    private static Field techgunAIAttackTime;
    private static Field techgunAIBurstCount;
    private static Field techgunAIburstAttackTime;
    private static final List<String> defaultZeroWeight;

    public static ItemStack getEquip(MobEntity e, EquipmentSlotType slot) {
        WeightedItemstackList eq = equips.get(slot);
        if (eq == null || eq.list.isEmpty() || eq.totalWeight == 0) {
            return ItemStack.field_190927_a;
        }
        int totalWeight = eq.totalWeight;
        return ((WeightedItemstack)WeightedRandom.func_76273_a((Random)e.field_70170_p.field_73012_v, (List)eq.list, (int)totalWeight)).getItem();
    }

    public static void initEquip() throws InvalidItemNameException {
        try {
            ForgeRegistries.ITEMS.forEach(item -> {
                ItemAI ai;
                if (item instanceof BowItem) {
                    equips.compute(EquipmentSlotType.MAINHAND, (s, l) -> l == null ? new WeightedItemstackList(Lists.newArrayList((Object[])new WeightedItemstack[]{new WeightedItemstack((Item)item, EquipmentList.getDefaultWeight(item))})) : l.add(new WeightedItemstack((Item)item, EquipmentList.getDefaultWeight(item))));
                }
                if ((ai = ItemAITasks.getAI(item)) != null) {
                    switch (ai.prefHand()) {
                        case BOTH: {
                            if (ai.type() == ItemAI.ItemType.NONSTRAFINGITEM) {
                                WeightedItemstack val = new WeightedItemstack((Item)item, EquipmentList.getDefaultWeight(item));
                                if (equips.get(EquipmentSlotType.MAINHAND).list.contains(val)) break;
                                equips.compute(EquipmentSlotType.OFFHAND, (s, l) -> l == null ? new WeightedItemstackList(Lists.newArrayList((Object[])new WeightedItemstack[]{val})) : l.add(val));
                                break;
                            }
                            if (item == Items.field_185155_bH) {
                                String potionItem = item.getRegistryName().toString() + "{Potion:\"minecraft:harming\"}";
                                equips.compute(EquipmentSlotType.MAINHAND, (s, l) -> l == null ? new WeightedItemstackList(Lists.newArrayList((Object[])new WeightedItemstack[]{new WeightedItemstack(potionItem, EquipmentList.getDefaultWeight(item), new ArrayList<String>())})) : l.add(new WeightedItemstack(potionItem, EquipmentList.getDefaultWeight(item), new ArrayList<String>())));
                                break;
                            }
                            equips.compute(EquipmentSlotType.MAINHAND, (s, l) -> l == null ? new WeightedItemstackList(Lists.newArrayList((Object[])new WeightedItemstack[]{new WeightedItemstack((Item)item, EquipmentList.getDefaultWeight(item))})) : l.add(new WeightedItemstack((Item)item, EquipmentList.getDefaultWeight(item))));
                            break;
                        }
                        case MAIN: {
                            equips.compute(EquipmentSlotType.MAINHAND, (s, l) -> l == null ? new WeightedItemstackList(Lists.newArrayList((Object[])new WeightedItemstack[]{new WeightedItemstack((Item)item, EquipmentList.getDefaultWeight(item))})) : l.add(new WeightedItemstack((Item)item, EquipmentList.getDefaultWeight(item))));
                            break;
                        }
                        case OFF: {
                            equips.compute(EquipmentSlotType.OFFHAND, (s, l) -> l == null ? new WeightedItemstackList(Lists.newArrayList((Object[])new WeightedItemstack[]{new WeightedItemstack((Item)item, EquipmentList.getDefaultWeight(item))})) : l.add(new WeightedItemstack((Item)item, EquipmentList.getDefaultWeight(item))));
                        }
                    }
                }
                if (item instanceof ArmorItem) {
                    switch (((ArmorItem)item).func_185083_B_()) {
                        case FEET: {
                            equips.compute(EquipmentSlotType.FEET, (s, l) -> l == null ? new WeightedItemstackList(Lists.newArrayList((Object[])new WeightedItemstack[]{new WeightedItemstack((Item)item, EquipmentList.getDefaultWeight(item))})) : l.add(new WeightedItemstack((Item)item, EquipmentList.getDefaultWeight(item))));
                            break;
                        }
                        case CHEST: {
                            equips.compute(EquipmentSlotType.CHEST, (s, l) -> l == null ? new WeightedItemstackList(Lists.newArrayList((Object[])new WeightedItemstack[]{new WeightedItemstack((Item)item, EquipmentList.getDefaultWeight(item))})) : l.add(new WeightedItemstack((Item)item, EquipmentList.getDefaultWeight(item))));
                            break;
                        }
                        case HEAD: {
                            equips.compute(EquipmentSlotType.HEAD, (s, l) -> l == null ? new WeightedItemstackList(Lists.newArrayList((Object[])new WeightedItemstack[]{new WeightedItemstack((Item)item, EquipmentList.getDefaultWeight(item))})) : l.add(new WeightedItemstack((Item)item, EquipmentList.getDefaultWeight(item))));
                            break;
                        }
                        case LEGS: {
                            equips.compute(EquipmentSlotType.LEGS, (s, l) -> l == null ? new WeightedItemstackList(Lists.newArrayList((Object[])new WeightedItemstack[]{new WeightedItemstack((Item)item, EquipmentList.getDefaultWeight(item))})) : l.add(new WeightedItemstack((Item)item, EquipmentList.getDefaultWeight(item))));
                        }
                    }
                }
                if ((item instanceof SwordItem || item instanceof ToolItem) && !EquipmentList.defaultBlackLists(item)) {
                    equips.compute(EquipmentSlotType.MAINHAND, (s, l) -> l == null ? new WeightedItemstackList(Lists.newArrayList((Object[])new WeightedItemstack[]{new WeightedItemstack((Item)item, EquipmentList.getDefaultWeight(item))})) : l.add(new WeightedItemstack((Item)item, EquipmentList.getDefaultWeight(item))));
                }
            });
            File conf = FMLPaths.CONFIGDIR.get().resolve("improvedmobs").resolve("equipment.json").toFile();
            JsonObject confObj = new JsonObject();
            if (!conf.exists()) {
                conf.createNewFile();
            } else {
                equips.clear();
                FileReader reader = new FileReader(conf);
                confObj = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                if (confObj == null) {
                    confObj = new JsonObject();
                }
                reader.close();
                ArrayList errors = new ArrayList();
                for (EquipmentSlotType key : EquipmentSlotType.values()) {
                    if (!confObj.has(key.toString())) continue;
                    JsonObject obj = (JsonObject)confObj.get(key.toString());
                    if (!obj.entrySet().isEmpty()) {
                        obj.entrySet().forEach(ent -> {
                            int weight = ((JsonElement)ent.getValue()).getAsInt();
                            equips.compute(key, (s, l) -> l == null ? new WeightedItemstackList(Lists.newArrayList((Object[])new WeightedItemstack[]{new WeightedItemstack((String)ent.getKey(), weight, errors)})) : l.add(new WeightedItemstack((String)ent.getKey(), weight, errors)));
                        });
                        continue;
                    }
                    equips.put(key, new WeightedItemstackList(new ArrayList<WeightedItemstack>()));
                }
                if (!errors.isEmpty()) {
                    throw new InvalidItemNameException("Invalid item names for following values: " + errors);
                }
            }
            for (EquipmentSlotType key : EquipmentSlotType.values()) {
                JsonObject eq = confObj.has(key.toString()) ? (JsonObject)confObj.get(key.toString()) : new JsonObject();
                equips.get(key).list.forEach(w -> eq.addProperty(w.configString, (Number)w.field_76292_a));
                JsonObject sorted = new JsonObject();
                ArrayList member = new ArrayList();
                eq.entrySet().forEach(ent -> member.add(ent.getKey()));
                Collections.sort(member);
                member.forEach(s -> sorted.addProperty(s, (Number)eq.get(s).getAsInt()));
                confObj.add(key.toString(), (JsonElement)sorted);
                equips.get(key).finishList();
            }
            conf.delete();
            conf.createNewFile();
            JsonWriter wr = GSON.newJsonWriter((Writer)new FileWriter(conf));
            GSON.toJson((Object)confObj, JsonObject.class, wr);
            wr.close();
        }
        catch (IOException e) {
            ImprovedMobs.logger.error("Error initializing equipment");
        }
    }

    private static boolean defaultBlackLists(Item item) {
        if (item instanceof ToolItem && !(item instanceof AxeItem)) {
            return true;
        }
        return item.getRegistryName().func_110624_b().equals("mobbattle");
    }

    private static int getDefaultWeight(Item item) {
        if (defaultZeroWeight.contains(item.getRegistryName().toString())) {
            return 0;
        }
        int weight = 1000;
        if (item instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            float fullProt = armor.func_200880_d().func_200902_b(EquipmentSlotType.HEAD) + armor.func_200880_d().func_200902_b(EquipmentSlotType.CHEST) + armor.func_200880_d().func_200902_b(EquipmentSlotType.LEGS) + armor.func_200880_d().func_200902_b(EquipmentSlotType.FEET);
            float averageDurability = (float)(armor.func_200880_d().func_200896_a(EquipmentSlotType.HEAD) + armor.func_200880_d().func_200896_a(EquipmentSlotType.CHEST) + armor.func_200880_d().func_200896_a(EquipmentSlotType.LEGS) + armor.func_200880_d().func_200896_a(EquipmentSlotType.FEET)) / 4.0f;
            if (averageDurability < 0.0f) {
                averageDurability = 0.0f;
            }
            float ench = armor.func_77619_b();
            float rep = armor.isRepairable(new ItemStack((IItemProvider)armor)) ? 0.9f : 1.15f;
            float vanillaMulti = armor.func_200880_d() == ArmorMaterial.LEATHER || armor.func_200880_d() == ArmorMaterial.GOLD || armor.func_200880_d() == ArmorMaterial.CHAIN || armor.func_200880_d() == ArmorMaterial.IRON || armor.func_200880_d() == ArmorMaterial.DIAMOND || armor.func_200880_d() == ArmorMaterial.NETHERITE || armor.func_200880_d() == ArmorMaterial.TURTLE ? 0.8f : 1.1f;
            weight = (int)((double)weight - ((double)fullProt * 3.3 + (double)averageDurability * 0.8 + (double)ench) * (double)rep * (double)vanillaMulti);
        } else if (item instanceof SwordItem) {
            float dmg = 10.0f + ((SwordItem)item).func_200894_d();
            weight = (int)((float)weight - dmg * dmg);
        } else if (item instanceof ToolItem) {
            ItemStack def = new ItemStack((IItemProvider)item);
            double dmg = 12.0 + ItemUtils.damage((ItemStack)def);
            weight = (int)((double)weight - dmg * dmg);
        } else if (item == Items.field_151033_d) {
            weight = 700;
        } else if (item instanceof ShieldItem) {
            weight = 850;
        } else if (item == Items.field_151129_at) {
            weight = 400;
        } else if (item == Items.field_151079_bi) {
            weight = 600;
        } else if (item == Items.field_151126_ay) {
            weight = 900;
        } else if (item instanceof PotionItem) {
            weight = 750;
        } else if (item instanceof BowItem) {
            weight = 850;
        } else if (item == Items.field_151134_bR) {
            weight = 800;
        } else if (item == Blocks.field_150335_W.func_199767_j()) {
            weight = 600;
        } else if (item == Items.field_203184_eO) {
            weight = 500;
        } else if (item instanceof CrossbowItem) {
            weight = 700;
        }
        return Math.max(weight, 1);
    }

    static {
        defaultZeroWeight = Lists.newArrayList((Object[])new String[]{"techguns:nucleardeathray", "techguns:grenadelauncher", "techguns:tfg", "techguns:guidedmissilelauncher", "techguns:rocketlauncher"});
    }

    public static class InvalidItemNameException
    extends Exception {
        private static final long serialVersionUID = -6736627280613384759L;

        public InvalidItemNameException(String message) {
            super(message);
        }
    }

    public static class WeightedItemstackList {
        private final List<WeightedItemstack> list;
        private int totalWeight;

        public WeightedItemstackList(List<WeightedItemstack> list) {
            this.list = list;
            this.list.removeIf(w -> ((WeightedItemstack)w).item == null);
            this.calculateTotalWeight();
        }

        private void calculateTotalWeight() {
            this.totalWeight = WeightedRandom.func_76272_a(this.list);
        }

        public void finishList() {
            this.list.removeIf(w -> w.field_76292_a == 0 || this.modBlacklist(((WeightedItemstack)w).item.getItem()));
            this.calculateTotalWeight();
        }

        private boolean modBlacklist(Item item) {
            if (Config.CommonConfig.equipmentModWhitelist) {
                for (String s : Config.CommonConfig.equipmentModBlacklist) {
                    if (!item.getRegistryName().func_110624_b().equals(s)) continue;
                    return false;
                }
                return true;
            }
            for (String s : Config.CommonConfig.equipmentModBlacklist) {
                if (!item.getRegistryName().func_110624_b().equals(s)) continue;
                return true;
            }
            return false;
        }

        public WeightedItemstackList add(WeightedItemstack item) {
            if (item.item == null) {
                return this;
            }
            this.list.remove(item);
            this.list.add(item);
            return this;
        }

        public String toString() {
            return String.format("TotalWeight: %d ; [%s]", this.totalWeight, this.list.toString());
        }
    }

    public static class WeightedItemstack
    extends WeightedRandom.Item
    implements Comparable<WeightedItemstack> {
        private final ExtendedItemStackWrapper item;
        public final String configString;

        public WeightedItemstack(Item item, int itemWeight) {
            super(itemWeight);
            this.item = new ExtendedItemStackWrapper(item.getRegistryName().toString());
            this.configString = item.getRegistryName().toString();
        }

        public WeightedItemstack(String item, int itemWeight, List<String> errors) {
            super(itemWeight);
            Item it;
            this.configString = item;
            String itemReg = item;
            CompoundNBT nbt = null;
            if (item.contains("{")) {
                int idx = item.indexOf("{");
                itemReg = item.substring(0, idx);
                try {
                    nbt = JsonToNBT.func_180713_a((String)item.substring(idx));
                }
                catch (CommandSyntaxException e) {
                    ImprovedMobs.logger.error("Error reading nbt from config {}", (Object)item.substring(idx));
                    e.printStackTrace();
                }
            }
            if ((it = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemReg))) == null) {
                errors.add(itemReg);
                this.item = null;
            } else {
                this.item = new ExtendedItemStackWrapper(itemReg).setNBT(nbt);
            }
        }

        public ItemStack getItem() {
            return this.item.getStack();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof WeightedItemstack) {
                WeightedItemstack oth = (WeightedItemstack)other;
                if (!this.item.getItem().getRegistryName().equals((Object)oth.item.getItem().getRegistryName())) {
                    return false;
                }
                if (this.item.getTag() == null && oth.item.getTag() != null) {
                    return false;
                }
                return this.item.getTag() == null || this.item.getTag().equals((Object)oth.item.getTag());
            }
            return false;
        }

        public int hashCode() {
            return (this.item.getItem().getRegistryName() + (this.item.getTag() != null ? this.item.getTag().toString() : "")).hashCode();
        }

        @Override
        public int compareTo(WeightedItemstack o) {
            return this.item.getItem().getRegistryName().toString().compareTo(o.item.getItem().getRegistryName().toString());
        }

        public String toString() {
            return String.format("Item: %s; Weight: %d", this.item.getItem().getRegistryName().toString(), this.field_76292_a);
        }
    }
}

