/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.improvedmobs.difficulty;

import com.flemmli97.improvedmobs.config.Config;
import com.flemmli97.improvedmobs.network.PacketDifficulty;
import com.flemmli97.improvedmobs.network.PacketHandler;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.silentchaos512.scalinghealth.utils.config.SHDifficulty;

public class DifficultyData
extends WorldSavedData {
    private static final String identifier = "Difficulty";
    private float difficultyLevel;
    private long prevTime;

    public DifficultyData() {
        this(identifier);
    }

    private DifficultyData(String id) {
        super(id);
    }

    public static DifficultyData get(World world) {
        return (DifficultyData)world.func_73046_m().func_241755_D_().func_217481_x().func_215752_a(DifficultyData::new, identifier);
    }

    public static float getDifficulty(World world, LivingEntity e) {
        if (Config.CommonConfig.useScalingHealthMod) {
            return (float)SHDifficulty.areaDifficulty((World)world, (BlockPos)e.func_233580_cy_());
        }
        return DifficultyData.get(world).getDifficulty();
    }

    public void increaseDifficultyBy(float amount, long time, MinecraftServer server) {
        this.difficultyLevel += amount;
        this.prevTime = time;
        this.func_76185_a();
        PacketHandler.sendToAll(new PacketDifficulty(this), server);
    }

    public void setDifficulty(float level, MinecraftServer server) {
        this.difficultyLevel = level;
        PacketHandler.sendToAll(new PacketDifficulty(this), server);
        this.func_76185_a();
    }

    public void addDifficulty(float level, MinecraftServer server) {
        this.difficultyLevel += level;
        PacketHandler.sendToAll(new PacketDifficulty(this), server);
        this.func_76185_a();
    }

    public float getDifficulty() {
        return this.difficultyLevel;
    }

    public long getPrevTime() {
        return this.prevTime;
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.difficultyLevel = nbt.func_74760_g(identifier);
        this.prevTime = nbt.func_74763_f("Time");
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        compound.func_74776_a(identifier, this.difficultyLevel);
        compound.func_74772_a("Time", this.prevTime);
        return compound;
    }
}

