/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.improvedmobs.mixin.pathfinding;

import com.flemmli97.improvedmobs.utils.INodeBreakable;
import com.flemmli97.improvedmobs.utils.PathFindingUtils;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.pathfinding.FlyingNodeProcessor;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IBlockReader;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FlyingNodeProcessor.class})
public abstract class FlyNodeMixin
extends NodeProcessor {
    @Unique
    private final Object2BooleanMap<AxisAlignedBB> collisionBreakableCache = new Object2BooleanOpenHashMap();

    @Inject(method={"postProcess"}, at={@At(value="RETURN")})
    private void clearStuff(CallbackInfo info) {
        this.collisionBreakableCache.clear();
    }

    @Inject(method={"openPoint"}, at={@At(value="HEAD")}, cancellable=true)
    private void breakableNodes(int x, int y, int z, CallbackInfoReturnable<PathPoint> info) {
        if (!((INodeBreakable)((Object)this)).canBreakBlocks()) {
            return;
        }
        PathPoint node = PathFindingUtils.floatingPathPointModifier(this.field_186326_b, (IBlockReader)this.field_176169_a, x, y, z, aabb -> (Boolean)this.collisionBreakableCache.computeIfAbsent(aabb, object -> !PathFindingUtils.noCollision(this.field_176169_a, (Entity)this.field_186326_b, aabb)), p -> super.func_176159_a(p.func_177958_n(), p.func_177956_o(), p.func_177952_p()));
        if (node != null) {
            info.setReturnValue((Object)node);
            info.cancel();
        }
    }
}

