/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.improvedmobs.utils;

import com.flemmli97.improvedmobs.config.Config;
import com.flemmli97.improvedmobs.utils.ItemAI;
import com.flemmli97.improvedmobs.utils.ItemAIs;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.LingeringPotionItem;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.SplashPotionItem;
import net.minecraft.util.Hand;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class ItemAITasks {
    private static final Map<Item, ItemAI> itemMap = new HashMap<Item, ItemAI>();

    public static void initAI() {
        ItemAITasks.initVanilla();
    }

    public static void registerAI(Item item, ItemAI ai) {
        itemMap.put(item, ai);
    }

    @Nullable
    public static ItemAI getAI(Item item) {
        return itemMap.get(item);
    }

    @Nullable
    public static Pair<ItemAI, Hand> getAI(MobEntity entity) {
        ItemStack heldMain = entity.func_184614_ca();
        ItemStack heldOff = entity.func_184592_cb();
        if (heldMain.func_77973_b() instanceof ArrowItem && heldOff.func_77973_b() instanceof BowItem) {
            entity.func_184201_a(EquipmentSlotType.MAINHAND, heldOff.func_77946_l());
            entity.func_184201_a(EquipmentSlotType.OFFHAND, heldMain.func_77946_l());
            heldMain = entity.func_184614_ca();
            heldOff = entity.func_184592_cb();
        }
        Hand hand = Hand.MAIN_HAND;
        ItemAI ai = itemMap.get(heldMain.func_77973_b());
        if ((ai == null || ai.prefHand() == ItemAI.UsableHand.OFF || ItemAITasks.blockedAI(entity, heldMain.func_77973_b()) || !ai.applies(heldMain)) && (ai = itemMap.get(heldOff.func_77973_b())) != null) {
            if (ai.prefHand() == ItemAI.UsableHand.MAIN || ai.isIncompatibleWith((LivingEntity)entity, heldMain) || ItemAITasks.blockedAI(entity, heldOff.func_77973_b()) || !ai.applies(heldOff)) {
                ai = null;
            } else {
                hand = Hand.OFF_HAND;
            }
        }
        return Pair.of((Object)ai, (Object)hand);
    }

    private static boolean blockedAI(MobEntity entity, Item item) {
        return Config.CommonConfig.mobListUseWhitelist && !Config.CommonConfig.itemuseBlacklist.contains(item.getRegistryName().toString()) || Config.CommonConfig.itemuseBlacklist.contains(item.getRegistryName().toString()) || Config.CommonConfig.entityItemConfig.preventUse((Entity)entity, item);
    }

    private static void initVanilla() {
        for (Item item : ForgeRegistries.ITEMS) {
            if (item instanceof SplashPotionItem) {
                ItemAITasks.registerAI(item, ItemAIs.SPLASH);
            }
            if (item instanceof LingeringPotionItem) {
                ItemAITasks.registerAI(item, ItemAIs.LINGERINGPOTIONS);
            }
            if (item instanceof CrossbowItem) {
                ItemAITasks.registerAI(item, ItemAIs.CROSSBOWS);
            }
            if (item instanceof BowItem) {
                ItemAITasks.registerAI(item, ItemAIs.BOWS);
            }
            if (!(item instanceof ShieldItem)) continue;
            ItemAITasks.registerAI(item, ItemAIs.SHIELDS);
        }
        ItemAITasks.registerAI(Items.field_151126_ay, ItemAIs.SNOWBALL);
        ItemAITasks.registerAI(Items.field_151079_bi, ItemAIs.ENDER_PEARL);
        ItemAITasks.registerAI(Items.field_151129_at, ItemAIs.LAVABUCKET);
        ItemAITasks.registerAI(Items.field_151033_d, ItemAIs.FLINT_N_STEEL);
        ItemAITasks.registerAI(Blocks.field_150335_W.func_199767_j(), ItemAIs.TNT);
        ItemAITasks.registerAI(Items.field_203184_eO, ItemAIs.TRIDENT);
        ItemAITasks.registerAI(Items.field_151134_bR, ItemAIs.ENCHANTEDBOOK);
    }
}

