/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.improvedmobs.utils;

import com.flemmli97.improvedmobs.config.Config;
import com.flemmli97.improvedmobs.utils.CustomBlockCollision;
import com.flemmli97.improvedmobs.utils.GeneralHelperMethods;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapeSpliterator;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.Region;
import net.minecraft.world.border.WorldBorder;

public class PathFindingUtils {
    public static PathPoint notFloatingPathPointModifier(MobEntity mob, IBlockReader getter, int x, int y, int z, int stepModifier, Direction dir, PathNodeType standingType, Function<BlockPos, PathNodeType> func, Function<AxisAlignedBB, Boolean> collision, Function<AxisAlignedBB, Boolean> collisionDefault, Function<BlockPos, PathPoint> PathPointGetter, Object2BooleanMap<Long> breakableMap) {
        BlockPos.Mutable pos = new BlockPos.Mutable(x, y, z);
        BlockState state = getter.func_180495_p((BlockPos)pos);
        if (((Boolean)breakableMap.computeIfAbsent((Object)BlockPos.func_218276_a((int)x, (int)y, (int)z), p -> PathFindingUtils.canBreak(state, (BlockPos)pos, mob))).booleanValue()) {
            AxisAlignedBB aabb = PathFindingUtils.createAxisAlignedBBForPos(getter, x, y, z, (double)mob.func_213311_cf() / 2.0, mob.func_213302_cg());
            if (stepModifier > 0 && !collisionDefault.apply(aabb.func_72321_a((double)(-dir.func_82601_c()), 0.0, (double)(-dir.func_82599_e()))).booleanValue()) {
                PathPoint PathPoint2 = PathPointGetter.apply((BlockPos)pos.func_181079_c(x, y + 1, z));
                PathPoint2.field_186287_m = PathNodeType.WALKABLE;
                PathPoint2.field_186286_l = Math.max(0.0f, PathPoint2.field_186286_l);
                return PathPoint2;
            }
            if (collision.apply(aabb.func_72317_d(0.0, -1.0, 0.0)).booleanValue()) {
                return null;
            }
            PathPoint PathPoint3 = PathPointGetter.apply((BlockPos)pos);
            PathPoint3.field_186287_m = PathNodeType.WALKABLE;
            PathPoint3.field_186286_l = Math.max(0.0f, PathPoint3.field_186286_l);
            PathNodeType below = func.apply((BlockPos)pos.func_181079_c(x, y - 1, z));
            if (below == PathNodeType.OPEN) {
                int fall = 0;
                BlockPos.Mutable lower = new BlockPos.Mutable(x, y, z);
                while (below == PathNodeType.OPEN) {
                    if (--y < 0) {
                        return null;
                    }
                    if (fall++ >= mob.func_82143_as()) {
                        PathPoint PathPoint2 = PathPointGetter.apply((BlockPos)lower.func_181079_c(x, y, z));
                        PathPoint2.field_186287_m = PathNodeType.BLOCKED;
                        PathPoint2.field_186286_l = -1.0f;
                        return PathPoint2;
                    }
                    below = func.apply((BlockPos)lower.func_181079_c(x, y, z));
                    float mobPathingMalus = mob.func_184643_a(below);
                    if (below != PathNodeType.OPEN && mobPathingMalus >= 0.0f) {
                        PathPoint3 = PathPointGetter.apply((BlockPos)lower.func_181079_c(x, y, z));
                        PathPoint3.field_186287_m = below;
                        PathPoint3.field_186286_l = Math.max(PathPoint3.field_186286_l, mobPathingMalus);
                        break;
                    }
                    if (!(mobPathingMalus < 0.0f)) continue;
                    return null;
                }
            }
            PathPoint3.field_186286_l += 6.0f;
            return PathPoint3;
        }
        if (stepModifier > 0) {
            BlockState above = getter.func_180495_p((BlockPos)pos.func_181079_c(x, y + 1, z));
            if (!((Boolean)breakableMap.computeIfAbsent((Object)BlockPos.func_218276_a((int)x, (int)(y + 1), (int)z), p -> PathFindingUtils.canBreak(above, (BlockPos)pos, mob))).booleanValue()) {
                return null;
            }
            AxisAlignedBB aabb = PathFindingUtils.createAxisAlignedBBForPos(getter, x, y + 1, z, (double)mob.func_213311_cf() / 2.0, mob.func_213302_cg());
            if (collision.apply(aabb).booleanValue()) {
                return null;
            }
            PathPoint PathPoint4 = PathPointGetter.apply((BlockPos)pos.func_181079_c(x, y, z));
            PathPoint4.field_186286_l = Math.max(0.0f, PathPoint4.field_186286_l);
            PathPoint4.field_186287_m = PathNodeType.WALKABLE;
            PathPoint4.field_186286_l += 6.0f;
            return PathPoint4;
        }
        return null;
    }

    public static PathPoint floatingPathPointModifier(MobEntity mob, IBlockReader getter, int x, int y, int z, Function<AxisAlignedBB, Boolean> collision, Function<BlockPos, PathPoint> PathPointGetter) {
        BlockPos.Mutable pos = new BlockPos.Mutable(x, y, z);
        BlockState state = getter.func_180495_p((BlockPos)pos);
        if (PathFindingUtils.canBreak(state, (BlockPos)pos, mob)) {
            AxisAlignedBB aabb = PathFindingUtils.createAxisAlignedBBForPos(getter, x, y, z, (double)mob.func_213311_cf() / 2.0, mob.func_213302_cg());
            if (collision.apply(aabb).booleanValue()) {
                return null;
            }
            PathPoint PathPoint2 = PathPointGetter.apply((BlockPos)pos);
            PathPoint2.field_186287_m = PathNodeType.WALKABLE;
            PathPoint2.field_186286_l += 2.0f;
            return PathPoint2;
        }
        return null;
    }

    public static boolean noCollision(Region level, Entity entity, AxisAlignedBB aABB) {
        Iterable shapes = () -> new CustomBlockCollision((ICollisionReader)level, entity, aABB);
        for (VoxelShape voxelShape : shapes) {
            if (voxelShape.func_197766_b()) continue;
            return false;
        }
        if (entity != null) {
            VoxelShape voxelShape2 = VoxelShapeSpliterator.func_234877_a_((WorldBorder)level.func_175723_af(), (AxisAlignedBB)aABB) ? level.func_175723_af().func_222521_a() : null;
            return voxelShape2 == null || !VoxelShapes.func_197879_c((VoxelShape)voxelShape2, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)aABB), (IBooleanFunction)IBooleanFunction.field_223238_i_);
        }
        return true;
    }

    public static AxisAlignedBB createAxisAlignedBBForPos(IBlockReader getter, int x, int y, int z, double widthHalf, double height) {
        double floor1 = WalkNodeProcessor.func_197682_a((IBlockReader)getter, (BlockPos)new BlockPos(x, y + 1, z));
        return new AxisAlignedBB((double)x - widthHalf + 0.5, floor1 + 0.001, (double)z - widthHalf + 0.5, (double)x + widthHalf + 0.5, height + floor1, (double)z + widthHalf + 0.5);
    }

    public static int createLadderPathPointFor(int PathPointID, PathPoint[] PathPoints, PathPoint origin, Function<BlockPos, PathPoint> PathPointGetter, IBlockReader getter, MobEntity mob) {
        PathPoint PathPoint2;
        BlockPos.Mutable pos = new BlockPos.Mutable(origin.field_75839_a, origin.field_75837_b + 1, origin.field_75838_c);
        if (getter.func_180495_p((BlockPos)pos).isLadder((IWorldReader)mob.field_70170_p, (BlockPos)pos, (LivingEntity)mob) && (PathPoint2 = PathPointGetter.apply((BlockPos)pos)) != null && !PathPoint2.field_75842_i) {
            PathPoint2.field_186286_l = 0.0f;
            PathPoint2.field_186287_m = PathNodeType.WALKABLE;
            if (PathPointID + 1 < PathPoints.length) {
                PathPoints[PathPointID++] = PathPoint2;
            }
        }
        pos.func_181079_c(pos.func_177958_n(), pos.func_177956_o() - 2, pos.func_177952_p());
        if (getter.func_180495_p((BlockPos)pos).isLadder((IWorldReader)mob.field_70170_p, (BlockPos)pos, (LivingEntity)mob) && (PathPoint2 = PathPointGetter.apply((BlockPos)pos)) != null && !PathPoint2.field_75842_i) {
            PathPoint2.field_186286_l = 0.0f;
            PathPoint2.field_186287_m = PathNodeType.WALKABLE;
            if (PathPointID + 1 < PathPoints.length) {
                PathPoints[PathPointID++] = PathPoint2;
            }
        }
        return PathPointID;
    }

    private static boolean canBreak(BlockState state, BlockPos pos, MobEntity entity) {
        return Config.CommonConfig.breakableBlocks.canBreak(state, pos, (IBlockReader)entity.field_70170_p, ISelectionContext.func_216374_a((Entity)entity)) && (GeneralHelperMethods.canHarvest(state, entity.func_184614_ca()) || GeneralHelperMethods.canHarvest(state, entity.func_184592_cb()));
    }

    public static boolean canBreak(BlockPos pos, MobEntity entity) {
        BlockState state = entity.field_70170_p.func_180495_p(pos);
        return Config.CommonConfig.breakableBlocks.canBreak(state, pos, (IBlockReader)entity.field_70170_p, ISelectionContext.func_216374_a((Entity)entity)) && (GeneralHelperMethods.canHarvest(state, entity.func_184614_ca()) || GeneralHelperMethods.canHarvest(state, entity.func_184592_cb()));
    }
}

