/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.tenshilib.client.render;

import com.flemmli97.tenshilib.client.render.RenderUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.vector.Vector3f;

public abstract class RenderTexture<T extends Entity>
extends EntityRenderer<T> {
    public final float xSize;
    public final float ySize;
    private int red = 255;
    private int green = 255;
    private int blue = 255;
    private int alpha = 255;
    public final int rows;
    public final int columns;
    public final int length;
    public final float uLength;
    public final float vLength;

    public RenderTexture(EntityRendererManager renderManager, float xSize, float ySize, int rows, int columns) {
        super(renderManager);
        this.xSize = xSize;
        this.ySize = ySize;
        this.rows = rows;
        this.columns = columns;
        this.length = rows * columns;
        this.uLength = 1.0f / (float)columns;
        this.vLength = 1.0f / (float)rows;
    }

    public void setColor(int hexColor) {
        this.setColor(hexColor >> 16 & 0xFF, hexColor >> 8 & 0xFF, hexColor & 0xFF, hexColor >> 24 & 0xFF);
    }

    public void setColor(int red, int green, int blue, int alpha) {
        this.red = red;
        this.blue = blue;
        this.green = green;
        this.alpha = alpha;
    }

    public void func_225623_a_(T entity, float rotation, float partialTicks, MatrixStack stack, IRenderTypeBuffer buffer, int packedLight) {
        float yaw = ((Entity)entity).field_70126_B + (((Entity)entity).field_70177_z - ((Entity)entity).field_70126_B) * partialTicks + 180.0f;
        float pitch = ((Entity)entity).field_70127_C + (((Entity)entity).field_70125_A - ((Entity)entity).field_70127_C) * partialTicks;
        if (this.facePlayer()) {
            stack.func_227863_a_(this.field_76990_c.func_229098_b_());
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        }
        float[] uvOffset = this.uvOffset(((Entity)entity).field_70173_aa);
        RenderUtils.renderTexture(stack, buffer, this.func_110775_a((Entity)entity), 0.0, 0.0, 0.0, this.xSize, this.ySize, this.red, this.blue, this.green, this.alpha, yaw + this.yawOffset(), pitch + this.pitchOffset(), uvOffset[0], uvOffset[1], this.uLength, this.vLength);
        super.func_225623_a_(entity, rotation, partialTicks, stack, buffer, packedLight);
    }

    public boolean facePlayer() {
        return true;
    }

    public float yawOffset() {
        return 0.0f;
    }

    public float pitchOffset() {
        return 0.0f;
    }

    public float[] uvOffset(int timer) {
        int frame = timer % this.length;
        return new float[]{(float)(frame % this.columns) * this.uLength, (float)frame / (float)this.columns * this.vLength};
    }
}

