/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.tenshilib.common.entity;

public class AnimatedAction {
    public static final AnimatedAction vanillaAttack = new AnimatedAction(20, 0, "vanilla");
    public static final AnimatedAction[] vanillaAttackOnly = new AnimatedAction[]{vanillaAttack};
    private final int length;
    private final int attackTime;
    private final String id;
    private float ticker;
    private float speed = 1.0f;

    public AnimatedAction(int length, int attackTime, String id) {
        this.length = length;
        this.attackTime = attackTime;
        this.id = id;
    }

    public AnimatedAction(int length, int attackTime, String id, boolean loops, float speedMod) {
        this(length, attackTime, id);
        this.speed = speedMod;
    }

    public AnimatedAction create() {
        return new AnimatedAction(this.length, this.attackTime, this.id);
    }

    public boolean tick() {
        float f;
        this.ticker += 1.0f * this.speed;
        return f >= (float)this.length;
    }

    public boolean canAttack() {
        return this.ticker == (float)this.attackTime;
    }

    public int getTick() {
        return (int)this.ticker;
    }

    public int getLength() {
        return this.length;
    }

    public int getAttackTime() {
        return this.attackTime;
    }

    public void reset() {
        this.ticker = 0.0f;
    }

    public String getID() {
        return this.id;
    }

    public String toString() {
        return "ID: " + this.id + "; length: " + this.length + "; attackTime: " + this.attackTime + "; speed: " + this.speed;
    }

    public boolean equals(Object o) {
        if (o instanceof AnimatedAction) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

