/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.tenshilib.common.entity;

import com.flemmli97.tenshilib.common.entity.EntityUtil;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.EndGatewayTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class EntityProjectile
extends Entity {
    private LivingEntity shooter;
    protected boolean inGround;
    protected int ticksInGround;
    protected int livingTicks;
    public List<UUID> attackedEntities = Lists.newArrayList();
    private BlockState ground;
    private BlockPos groundPos;
    protected static final DataParameter<String> shooterUUID = EntityDataManager.func_187226_a(EntityProjectile.class, (IDataSerializer)DataSerializers.field_187194_d);

    public EntityProjectile(EntityType<? extends EntityProjectile> type, World world) {
        super(type, world);
    }

    public EntityProjectile(EntityType<? extends EntityProjectile> type, World world, double x, double y, double z) {
        this(type, world);
        this.func_70107_b(x, y, z);
    }

    public EntityProjectile(EntityType<? extends EntityProjectile> type, World world, LivingEntity shooter) {
        this(type, world, shooter.func_226277_ct_(), shooter.func_226278_cu_() + (double)shooter.func_70047_e() - (double)0.1f, shooter.func_226281_cx_());
        this.shooter = shooter;
        this.field_70180_af.func_187227_b(shooterUUID, (Object)shooter.func_110124_au().toString());
        this.func_70101_b(shooter.field_70177_z, shooter.field_70125_A);
    }

    public boolean isPiercing() {
        return false;
    }

    public int maxPierceAmount() {
        return -1;
    }

    public float radius() {
        return 0.0f;
    }

    public int livingTicks() {
        return this.livingTicks;
    }

    public int livingTickMax() {
        return 6000;
    }

    public boolean canHitShooter() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(shooterUUID, (Object)"");
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void shoot(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, velocity, inaccuracy);
        Vector3d throwerMotion = entityThrower.func_213322_ci();
        this.func_213317_d(this.func_213322_ci().func_72441_c(throwerMotion.field_72450_a, entityThrower.func_233570_aj_() ? 0.0 : throwerMotion.field_72448_b, throwerMotion.field_72449_c));
        this.func_213322_ci().func_72441_c(throwerMotion.field_72450_a, 0.0, throwerMotion.field_72449_c);
    }

    public void shootAtPosition(double x, double y, double z, float velocity, float inaccuracy) {
        Vector3d dir = new Vector3d(x - this.func_226277_ct_(), y - this.func_226278_cu_(), z - this.func_226281_cx_()).func_186678_a((double)(1.0f / velocity));
        this.shoot(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c, velocity, inaccuracy);
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        Vector3d vector3d = new Vector3d(x, y, z).func_72432_b().func_72441_c(this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy).func_186678_a((double)velocity);
        this.func_213317_d(vector3d);
        float f = MathHelper.func_76133_a((double)EntityProjectile.func_213296_b((Vector3d)vector3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vector3d.field_72448_b, (double)f) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.ticksInGround = 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.func_213293_j(x, y, z);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.2957763671875);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        }
    }

    public void setInGround(BlockPos pos) {
        BlockState state = this.field_70170_p.func_180495_p(pos);
        if (!state.func_185904_a().func_76220_a()) {
            this.inGround = false;
            return;
        }
        this.inGround = true;
        this.groundPos = pos;
        this.ground = state;
    }

    public void func_70071_h_() {
        float friction;
        super.func_70071_h_();
        ++this.livingTicks;
        if (this.livingTicks > this.livingTickMax()) {
            this.func_70106_y();
        }
        Vector3d motion = this.func_213322_ci();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)EntityProjectile.func_213296_b((Vector3d)motion));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)motion.field_72450_a, (double)motion.field_72449_c) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)motion.field_72448_b, (double)f) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        BlockState inState = this.field_70170_p.func_180495_p(this.func_233580_cy_());
        if (this.inGround) {
            if (inState != this.ground && this.noGround()) {
                this.resetInGround();
            } else if (!this.field_70170_p.field_72995_K) {
                ++this.ticksInGround;
                if (this.ticksInGround == 1200) {
                    this.func_70106_y();
                }
            }
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.doCollision();
        }
        double newX = this.func_226277_ct_() + motion.field_72450_a;
        double newY = this.func_226278_cu_() + motion.field_72448_b;
        double newZ = this.func_226281_cx_() + motion.field_72449_c;
        float f = MathHelper.func_76133_a((double)EntityProjectile.func_213296_b((Vector3d)motion));
        this.field_70177_z = this.updateRotation(this.field_70126_B, (float)(MathHelper.func_181159_b((double)motion.field_72450_a, (double)motion.field_72449_c) * 57.29577951308232));
        this.field_70125_A = this.updateRotation(this.field_70127_C, (float)(MathHelper.func_181159_b((double)motion.field_72448_b, (double)f) * 57.2957763671875));
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_() * 0.25, this.func_226278_cu_() * 0.25, this.func_226281_cx_() * 0.25, motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
            }
            friction = 0.8f;
        } else {
            friction = this.motionReduction();
        }
        this.func_213317_d(motion.func_186678_a((double)friction));
        if (!this.func_189652_ae()) {
            this.func_213317_d(this.func_213322_ci().func_178786_a(0.0, (double)this.getGravityVelocity(), 0.0));
        }
        this.func_70107_b(newX, newY, newZ);
    }

    private float updateRotation(float prev, float current) {
        while (current - prev < -180.0f) {
            prev -= 360.0f;
        }
        while (current - prev >= 180.0f) {
            prev += 360.0f;
        }
        return MathHelper.func_219799_g((float)0.2f, (float)prev, (float)current);
    }

    private void doCollision() {
        EntityRayTraceResult res;
        Vector3d to;
        Vector3d pos = this.func_213303_ch();
        BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(pos, to = pos.func_178787_e(this.func_213322_ci()), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
            to = raytraceresult.func_216347_e();
        }
        while ((res = this.getEntityHit(pos, to)) != null) {
            if (ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)res)) continue;
            this.onEntityHit(res);
            this.attackedEntities.add(res.func_216348_a().func_110124_au());
            if (this.maxPierceAmount() == -1 || this.attackedEntities.size() <= this.maxPierceAmount()) continue;
            this.onReachMaxPierce();
        }
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.func_216350_a();
            BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
            if (blockstate.func_203425_a(Blocks.field_150427_aO)) {
                this.func_181015_d(blockpos);
            } else if (blockstate.func_203425_a(Blocks.field_185775_db)) {
                TileEntity tileentity = this.field_70170_p.func_175625_s(blockpos);
                if (tileentity instanceof EndGatewayTileEntity && EndGatewayTileEntity.func_242690_a((Entity)this)) {
                    ((EndGatewayTileEntity)tileentity).func_195496_a((Entity)this);
                }
            } else if (!ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
                this.onBlockHit(raytraceresult);
            }
        }
    }

    private boolean noGround() {
        return this.inGround && this.field_70170_p.func_226664_a_(new AxisAlignedBB(this.func_213303_ch(), this.func_213303_ch()).func_186662_g(0.06));
    }

    private void resetInGround() {
        this.inGround = false;
        this.func_213317_d(this.func_213322_ci().func_216372_d((double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f)));
        this.ticksInGround = 0;
    }

    public void func_213315_a(MoverType type, Vector3d to) {
        super.func_213315_a(type, to);
        if (type != MoverType.SELF && this.noGround()) {
            this.resetInGround();
        }
    }

    private boolean canHit(Entity entity) {
        if (entity.func_70067_L() && (this.getShooter() == null || !this.getShooter().func_184223_x(entity) && (this.canHitShooter() && this.field_70173_aa > 2 || entity != this.getShooter()))) {
            return !this.attackedEntities.contains(entity.func_110124_au());
        }
        return false;
    }

    private EntityRayTraceResult getEntityHit(Vector3d from, Vector3d to) {
        if (this.isPiercing()) {
            if (this.attackedEntities.size() < this.maxPierceAmount()) {
                return ProjectileHelper.func_221269_a((World)this.field_70170_p, (Entity)this, (Vector3d)from, (Vector3d)to, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), this::canHit);
            }
            return null;
        }
        if (this.attackedEntities.size() < 1) {
            return ProjectileHelper.func_221269_a((World)this.field_70170_p, (Entity)this, (Vector3d)from, (Vector3d)to, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), this::canHit);
        }
        return null;
    }

    protected float getGravityVelocity() {
        return 0.03f;
    }

    protected float motionReduction() {
        return 0.99f;
    }

    protected abstract void onEntityHit(EntityRayTraceResult var1);

    protected abstract void onBlockHit(BlockRayTraceResult var1);

    protected void onReachMaxPierce() {
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.inGround = compound.func_74767_n("InGround");
        if (this.inGround) {
            int[] arr = compound.func_74759_k("GroundPos");
            this.setInGround(new BlockPos(arr[0], arr[1], arr[2]));
        }
        if (compound.func_74764_b("Shooter")) {
            this.field_70180_af.func_187227_b(shooterUUID, (Object)compound.func_74779_i("Shooter"));
        }
        this.shooter = this.getShooter();
        this.livingTicks = compound.func_74762_e("LivingTicks");
        ListNBT list = compound.func_150295_c("AttackedEntities", 8);
        list.forEach(tag -> this.attackedEntities.add(UUID.fromString(tag.func_150285_a_())));
    }

    protected void func_213281_b(CompoundNBT compound) {
        if (this.inGround) {
            compound.func_74783_a("GroundPos", new int[]{this.groundPos.func_177958_n(), this.groundPos.func_177956_o(), this.groundPos.func_177952_p()});
        }
        compound.func_74757_a("InGround", this.inGround);
        compound.func_74778_a("Shooter", (String)this.field_70180_af.func_187225_a(shooterUUID));
        compound.func_74768_a("LivingTicks", this.livingTicks);
        ListNBT list = new ListNBT();
        this.attackedEntities.forEach(uuid -> list.add((Object)StringNBT.func_229705_a_((String)uuid.toString())));
        compound.func_218657_a("AttackedEntities", (INBT)list);
    }

    @Nullable
    public LivingEntity getShooter() {
        if (this.shooter == null && !((String)this.field_70180_af.func_187225_a(shooterUUID)).isEmpty()) {
            this.shooter = EntityUtil.findFromUUID(LivingEntity.class, this.field_70170_p, UUID.fromString((String)this.field_70180_af.func_187225_a(shooterUUID)));
        }
        return this.shooter;
    }
}

