/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.tenshilib.common.utils;

import com.flemmli97.tenshilib.common.utils.CircleSector;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class RayTraceUtils {
    public static List<LivingEntity> getEntities(LivingEntity entity, float reach, float aoe) {
        return RayTraceUtils.getEntitiesIn(LivingEntity.class, entity, entity.func_213303_ch().func_72441_c(0.0, (double)(entity.func_213302_cg() / 2.0f), 0.0), entity.func_70676_i(1.0f), reach, aoe, null);
    }

    public static <T extends LivingEntity> List<T> getEntitiesIn(Class<T> clss, LivingEntity entity, Vector3d pos, Vector3d look, float reach, float aoe, Predicate<T> pred) {
        CircleSector circ = new CircleSector(pos, look, reach, aoe, (Entity)entity);
        return entity.field_70170_p.func_175647_a(clss, entity.func_174813_aQ().func_186662_g((double)reach), living -> living != entity && (pred == null || pred.test(living)) && !living.func_184191_r((Entity)entity) && living.func_70067_L() && circ.intersects(living.field_70170_p, living.func_174813_aQ()));
    }

    public static RayTraceResult calculateEntityFromLook(LivingEntity entity, float reach) {
        return RayTraceUtils.calculateEntityFromLook(entity, reach, Entity.class);
    }

    public static RayTraceResult calculateEntityFromLook(LivingEntity entity, float reach, Class<? extends Entity> clss) {
        return RayTraceUtils.calculateEntityFromLook(entity, entity.func_174824_e(1.0f), entity.func_70676_i(1.0f), reach, clss, null);
    }

    public static RayTraceResult calculateEntityFromLook(LivingEntity entity, Vector3d pos, Vector3d dir, float reach, Class<? extends Entity> clss, @Nullable Predicate<? super Entity> pred) {
        BlockRayTraceResult blocks = entity.field_70170_p.func_217299_a(new RayTraceContext(pos, pos.func_72441_c(dir.field_72450_a * (double)reach, dir.field_72448_b * (double)reach, dir.field_72449_c * (double)reach), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)entity));
        reach = (float)blocks.func_216347_e().func_72438_d(pos);
        Vector3d rangeVec = pos.func_72441_c(dir.field_72450_a * (double)reach, dir.field_72448_b * (double)reach, dir.field_72449_c * (double)reach);
        List list = entity.field_70170_p.func_175647_a(clss, entity.func_174813_aQ().func_72321_a(dir.field_72450_a * (double)reach, dir.field_72448_b * (double)reach, dir.field_72449_c * (double)reach).func_72321_a(1.0, 1.0, 1.0), t -> EntityPredicates.field_180132_d.test(t) && t != null && t != entity && t.func_70067_L() && (pred == null || pred.test((Entity)t)));
        for (Entity e : list) {
            double d3;
            AxisAlignedBB axisalignedbb = e.func_174813_aQ().func_186662_g((double)e.func_70111_Y());
            Optional raytraceresult = axisalignedbb.func_216365_b(pos, rangeVec);
            if (!raytraceresult.isPresent() || !((d3 = pos.func_72438_d((Vector3d)raytraceresult.get())) < (double)reach)) continue;
            Vector3d hitVec = (Vector3d)raytraceresult.get();
            return new EntityRayTraceResult(e, hitVec);
        }
        return null;
    }

    public static BlockPos randomPosAround(World world, Entity e, BlockPos pos, int range, boolean grounded, Random rand) {
        int randX = pos.func_177958_n() + rand.nextInt(2 * range) - range;
        int randY = pos.func_177956_o() + rand.nextInt(2 * range) - range;
        int randZ = pos.func_177952_p() + rand.nextInt(2 * range) - range;
        if (!grounded) {
            BlockPos pos1 = new BlockPos(randX, randY, randZ);
            while (Math.abs(randY - pos.func_177956_o()) < range && world.func_226666_b_(e, e.func_174813_aQ().func_186670_a(pos1)).allMatch(VoxelShape::func_197766_b)) {
                pos1 = pos1.func_177984_a();
            }
            return pos1;
        }
        BlockPos pos1 = new BlockPos(randX, 0, randZ);
        while (pos1.func_177956_o() < 255 && !world.func_180495_p(pos1.func_177977_b()).func_215682_a((IBlockReader)world, pos1.func_177977_b(), e, Direction.UP) || world.func_226666_b_(e, e.func_174813_aQ().func_186670_a(pos1)).allMatch(VoxelShape::func_197766_b)) {
            pos1 = pos1.func_177984_a();
        }
        return pos1;
    }

    public static RayTraceResult entityRayTrace(Entity e, float range, RayTraceContext.BlockMode blockMode, RayTraceContext.FluidMode fluidMode, boolean includeEntities, @Nullable Predicate<Entity> pred) {
        Vector3d posEye = e.func_174824_e(1.0f);
        Vector3d look = posEye.func_178787_e(e.func_70040_Z().func_186678_a((double)range));
        if (includeEntities) {
            EntityRayTraceResult raytraceresult1;
            BlockRayTraceResult raytraceresult = e.field_70170_p.func_217299_a(new RayTraceContext(posEye, look, blockMode, fluidMode, e));
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
                look = raytraceresult.func_216347_e();
            }
            if ((raytraceresult1 = ProjectileHelper.func_221269_a((World)e.field_70170_p, (Entity)e, (Vector3d)posEye, (Vector3d)look, (AxisAlignedBB)e.func_174813_aQ().func_216361_a(look).func_186662_g(1.0), pred)) != null) {
                raytraceresult = raytraceresult1;
            }
            return raytraceresult;
        }
        return e.field_70170_p.func_217299_a(new RayTraceContext(posEye, look, blockMode, fluidMode, e));
    }
}

