/*
 * Decompiled with CFR 0.152.
 */
package einstein.einsteins_library.util;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.brain.task.GiveHeroGiftsTask;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.DesertVillagePools;
import net.minecraft.world.gen.feature.structure.PlainsVillagePools;
import net.minecraft.world.gen.feature.structure.SavannaVillagePools;
import net.minecraft.world.gen.feature.structure.SnowyVillagePools;
import net.minecraft.world.gen.feature.structure.TaigaVillagePools;
import net.minecraft.world.gen.feature.template.ProcessorLists;
import net.minecraft.world.gen.feature.template.StructureProcessorList;
import net.minecraftforge.coremod.api.ASMAPI;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="einsteins_library", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistryHandler {
    public static <T extends Item> T registerItem(String modid, String name, T item) {
        item.setRegistryName(new ResourceLocation(modid, name));
        ForgeRegistries.ITEMS.register(item);
        return item;
    }

    public static <T extends Item> T registerItem(String modid, String dependencyModid, String name, T item) {
        item.setRegistryName(new ResourceLocation(modid, name));
        if (ModList.get().isLoaded(dependencyModid)) {
            ForgeRegistries.ITEMS.register(item);
        }
        return item;
    }

    public static <T extends Block> T registerBlock(String modid, String name, T block, ItemGroup tab) {
        ResourceLocation resource = new ResourceLocation(modid, name);
        block.setRegistryName(resource);
        BlockItem item = new BlockItem(block, new Item.Properties().func_200916_a(tab));
        item.setRegistryName(resource);
        ForgeRegistries.BLOCKS.register(block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
        return block;
    }

    public static <T extends Block> T registerBlock(String modid, String name, T block) {
        block.setRegistryName(new ResourceLocation(modid, name));
        ForgeRegistries.BLOCKS.register(block);
        return block;
    }

    public static <T extends Block> T registerBlock(String modid, String dependencyModid, String name, T block, ItemGroup tab) {
        ResourceLocation resource = new ResourceLocation(modid, name);
        block.setRegistryName(resource);
        BlockItem item = new BlockItem(block, new Item.Properties().func_200916_a(tab));
        item.setRegistryName(resource);
        if (ModList.get().isLoaded(dependencyModid)) {
            ForgeRegistries.BLOCKS.register(block);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
        }
        return block;
    }

    public static <T extends Block> T registerBlock(String modid, String dependencyModid, String name, T block) {
        block.setRegistryName(new ResourceLocation(modid, name));
        if (ModList.get().isLoaded(dependencyModid)) {
            ForgeRegistries.BLOCKS.register(block);
        }
        return block;
    }

    public static <T extends Entity> EntityType<T> registerEntity(String modid, String name, EntityType.Builder<T> builder) {
        ResourceLocation resource = new ResourceLocation(modid, name);
        EntityType entity = builder.func_206830_a(resource.toString());
        entity.setRegistryName(resource);
        ForgeRegistries.ENTITIES.register((IForgeRegistryEntry)entity);
        return entity;
    }

    public static SoundEvent registerSound(String modid, String name) {
        ResourceLocation resource = new ResourceLocation(modid, name);
        SoundEvent soundEvent = new SoundEvent(resource);
        soundEvent.setRegistryName(resource);
        ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)soundEvent);
        return soundEvent;
    }

    public static SoundType registerSoundType(float volume, float pitch, SoundEvent breakSound, SoundEvent stepSound, SoundEvent placeSound, SoundEvent hitSound, SoundEvent fallSound) {
        SoundType soundType = new SoundType(volume, pitch, breakSound, stepSound, placeSound, hitSound, fallSound);
        return soundType;
    }

    public static Enchantment registerEnchantment(String modid, String name, Enchantment enchantment) {
        enchantment.setRegistryName(new ResourceLocation(modid, name));
        ForgeRegistries.ENCHANTMENTS.register((IForgeRegistryEntry)enchantment);
        return enchantment;
    }

    public static BannerPattern registerBannerPattern(String modid, String name, boolean hasPatternItem) {
        return BannerPattern.create((String)name.toUpperCase(), (String)name, (String)(modid + "." + name), (boolean)hasPatternItem);
    }

    public static Effect registerPotionEffect(String modid, String name, Effect potionEffect) {
        potionEffect.setRegistryName(modid, name);
        ForgeRegistries.POTIONS.register((IForgeRegistryEntry)potionEffect);
        return potionEffect;
    }

    public static Potion registerPotion(String modid, String name, Potion potion) {
        potion.setRegistryName(modid, name);
        ForgeRegistries.POTION_TYPES.register((IForgeRegistryEntry)potion);
        return potion;
    }

    public static BasicParticleType registerParticle(String modid, String name, boolean alwaysShow) {
        BasicParticleType particleType = new BasicParticleType(alwaysShow);
        particleType.setRegistryName(modid, name);
        ForgeRegistries.PARTICLE_TYPES.register((IForgeRegistryEntry)particleType);
        return particleType;
    }

    public static PointOfInterestType registerPOI(String modid, String name, Block block) {
        PointOfInterestType poi = new PointOfInterestType(name, PointOfInterestType.func_221042_a((Block)block), 1, 1);
        poi.setRegistryName(modid, name);
        ForgeRegistries.POI_TYPES.register((IForgeRegistryEntry)poi);
        return poi;
    }

    public static VillagerProfession registerProfession(String modid, String name, PointOfInterestType poi, SoundEvent workSound) {
        VillagerProfession profession = new VillagerProfession(name, poi, ImmutableSet.of(), ImmutableSet.of(), workSound);
        profession.setRegistryName(modid, name);
        ForgeRegistries.PROFESSIONS.register((IForgeRegistryEntry)profession);
        return profession;
    }

    public static VillagerProfession registerProfession(String modid, String name, PointOfInterestType poi, SoundEvent workSound, String gift) {
        VillagerProfession profession = new VillagerProfession(name, poi, ImmutableSet.of(), ImmutableSet.of(), workSound);
        profession.setRegistryName(modid, name);
        GiveHeroGiftsTask.field_220403_a.put(profession, new ResourceLocation(modid, gift));
        ForgeRegistries.PROFESSIONS.register((IForgeRegistryEntry)profession);
        return profession;
    }

    public static <T extends Fluid> T registerFluid(String modid, String name, T fluid) {
        fluid.setRegistryName(modid, name);
        ForgeRegistries.FLUIDS.register(fluid);
        return fluid;
    }

    public static ForgeFlowingFluid.Properties registerFluidProperties(String modid, String name, Supplier<FlowingFluid> still, Supplier<FlowingFluid> flowing) {
        String location = "block/" + name;
        return new ForgeFlowingFluid.Properties(still, flowing, FluidAttributes.builder((ResourceLocation)new ResourceLocation(modid, location + "_still"), (ResourceLocation)new ResourceLocation(modid, location + "_flowing")).viscosity(500).density(1400));
    }

    public static <T extends TileEntity> TileEntityType<T> registerTileEntity(String modid, String name, TileEntityType.Builder<T> builder) {
        TileEntityType tile_entity = builder.func_206865_a(null);
        tile_entity.setRegistryName(new ResourceLocation(modid, name));
        ForgeRegistries.TILE_ENTITIES.register((IForgeRegistryEntry)tile_entity);
        return tile_entity;
    }

    public static PaintingType registerPainting(String modid, String name, int width, int height) {
        PaintingType painting = new PaintingType(width, height);
        painting.setRegistryName(modid, name);
        ForgeRegistries.PAINTING_TYPES.register((IForgeRegistryEntry)painting);
        return painting;
    }

    public static <T extends Container> ContainerType<T> registerContainerType(String modid, String name, ContainerType.IFactory<T> factory) {
        ContainerType container = new ContainerType(factory);
        container.setRegistryName(modid, name);
        ForgeRegistries.CONTAINERS.register((IForgeRegistryEntry)container);
        return container;
    }

    public static <T extends IRecipe<?>> IRecipeType<T> registerRecipeType(String modid, final String name) {
        return (IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)new ResourceLocation(modid, name), (Object)new IRecipeType<T>(){

            public String toString() {
                return name.toString();
            }
        });
    }

    public static <T extends IRecipeSerializer<? extends IRecipe<?>>> T registerSerializer(String modid, String name, T serializer) {
        serializer.setRegistryName(new ResourceLocation(modid + ":" + name));
        ForgeRegistries.RECIPE_SERIALIZERS.register(serializer);
        return serializer;
    }

    public static void registerVillageBuilding(String modid, String location, int weight) {
        PlainsVillagePools.func_214744_a();
        DesertVillagePools.func_222739_a();
        SavannaVillagePools.func_214745_a();
        SnowyVillagePools.func_214746_a();
        TaigaVillagePools.func_214806_a();
        for (String biome : new String[]{"plains", "snowy", "savanna", "desert", "taiga"}) {
            JigsawPattern pattern = (JigsawPattern)WorldGenRegistries.field_243656_h.func_82594_a(new ResourceLocation("minecraft:village/" + biome + "/houses"));
            if (pattern == null) {
                return;
            }
            Function building = JigsawPiece.func_242851_a((String)(modid + ":village/" + biome + "/" + location), (StructureProcessorList)ProcessorLists.field_244107_g);
            JigsawPiece buildingPiece = (JigsawPiece)building.apply(JigsawPattern.PlacementBehaviour.RIGID);
            try {
                String name = ASMAPI.mapField((String)"field_214953_e");
                Field field = JigsawPattern.class.getDeclaredField(name);
                field.setAccessible(true);
                String name2 = ASMAPI.mapField((String)"field_214952_d");
                Field field2 = JigsawPattern.class.getDeclaredField(name2);
                field2.setAccessible(true);
                List list = (List)field.get(pattern);
                for (int i = 0; i < 1; ++i) {
                    list.add(buildingPiece);
                }
                List list2 = (List)field2.get(pattern);
                list2.add(Pair.of((Object)buildingPiece, (Object)weight));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

