/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc;

import cpw.mods.modlauncher.api.INameMappingService;
import einstein.jmc.JMCItemGroup;
import einstein.jmc.init.ModBlocks;
import einstein.jmc.init.ModClientConfigs;
import einstein.jmc.init.ModPotions;
import einstein.jmc.init.ModServerConfigs;
import einstein.jmc.init.ModTileEntityType;
import einstein.jmc.init.ModVillagers;
import einstein.jmc.util.EventHandler;
import einstein.jmc.world.gen.village.RegisterDesertBakery;
import einstein.jmc.world.gen.village.RegisterPlainsBakery;
import einstein.jmc.world.gen.village.RegisterSavannaBakery;
import einstein.jmc.world.gen.village.RegisterSnowyBakery;
import einstein.jmc.world.gen.village.RegisterTaigaBakery;
import java.lang.reflect.Field;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Items;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="jmc")
public class JustMoreCakes {
    public static final String MODID = "jmc";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final JMCItemGroup JMC_GROUP = new JMCItemGroup(ItemGroup.field_78032_a.length, "jmc_tab");
    public static JustMoreCakes instance;
    private Field maxItemStackSize;

    public JustMoreCakes() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::doClientStuff);
        ModVillagers.PROFESSIONS.register(modEventBus);
        ModVillagers.POI_TYPES.register(modEventBus);
        ModPotions.POTIONS.register(modEventBus);
        ModPotions.POTION_EFFECTS.register(modEventBus);
        ModTileEntityType.TILE_ENTITY_TYPES.register(modEventBus);
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ModServerConfigs.SERVERSPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ModClientConfigs.CLIENTSPEC);
        this.accessStackSize();
        if (this.maxItemStackSize != null) {
            modEventBus.addListener(this::resizeCakeStack);
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        RegisterDesertBakery.updatePools();
        RegisterPlainsBakery.updatePools();
        RegisterSavannaBakery.updatePools();
        RegisterSnowyBakery.updatePools();
        RegisterTaigaBakery.updatePools();
        DeferredWorkQueue.runLater(() -> ModVillagers.registerVillagers());
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        DeferredWorkQueue.runLater(() -> ModPotions.registerPotionRecipes());
    }

    @Nullable
    private static Block missingBlock(String name) {
        switch (name) {
            case "cheese_cake": {
                return ModBlocks.CHEESECAKE;
            }
            case "triple_decker_cake": {
                return ModBlocks.THREE_TIERED_CAKE;
            }
        }
        return null;
    }

    @SubscribeEvent
    void missingItems(RegistryEvent.MissingMappings<Item> event) {
        JustMoreCakes.handleMissingMappings(event, MODID, name -> {
            switch (name) {
                case "cheese_cake": {
                    return ModBlocks.CHEESECAKE.func_199767_j();
                }
                case "triple_decker_cake": {
                    return ModBlocks.THREE_TIERED_CAKE.func_199767_j();
                }
            }
            Block block = JustMoreCakes.missingBlock(name);
            return block == null ? null : block.func_199767_j();
        });
    }

    @SubscribeEvent
    void missingBlocks(RegistryEvent.MissingMappings<Block> event) {
        JustMoreCakes.handleMissingMappings(event, MODID, JustMoreCakes::missingBlock);
    }

    public static <T extends IForgeRegistryEntry<T>> void handleMissingMappings(RegistryEvent.MissingMappings<T> event, String modID, Function<String, T> handler) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            IForgeRegistryEntry value;
            if (!modID.equals(mapping.key.func_110624_b()) || (value = (IForgeRegistryEntry)handler.apply(mapping.key.func_110623_a())) == null) continue;
            mapping.remap(value);
        }
    }

    private void accessStackSize() {
        try {
            Field field = Item.class.getDeclaredField(ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.FIELD, (String)"field_77777_bU"));
            field.setAccessible(true);
            this.maxItemStackSize = field;
            LOGGER.debug("Item.Properties.maxStackSize is now accessible");
        }
        catch (Throwable t) {
            LOGGER.catching(Level.WARN, t);
        }
    }

    private void resizeCakeStack(FMLCommonSetupEvent event) {
        try {
            this.maxItemStackSize.setInt(Items.field_222070_lD, 64);
            LOGGER.debug("Changed cake's max stack size to 64");
        }
        catch (Throwable t) {
            LOGGER.catching(Level.WARN, t);
        }
    }
}

