/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.init;

import net.minecraftforge.common.ForgeConfigSpec;

public class ModServerConfigs {
    public static ForgeConfigSpec.Builder SERVER_BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.IntValue POISON_CAKE_POISON_DUR;
    public static final ForgeConfigSpec.IntValue GAPPLE_CAKE_REGEN_DUR;
    public static final ForgeConfigSpec.IntValue GAPPLE_CAKE_RES_DUR;
    public static final ForgeConfigSpec.IntValue GAPPLE_CAKE_ABSORPTION_DUR;
    public static final ForgeConfigSpec.IntValue FIREY_CAKE_FIRE_RES_DUR;
    public static final ForgeConfigSpec.IntValue FIREY_CAKE_ON_FIRE_DUR;
    public static final ForgeConfigSpec.IntValue SLIME_CAKE_JUMP_BOOST_DUR;
    public static final ForgeConfigSpec.IntValue SLIME_CAKE_RES_DUR;
    public static final ForgeConfigSpec.IntValue SLIME_CAKE_BOUNCING_DUR;
    public static final ForgeConfigSpec.IntValue BEETROOT_CAKE_REGEN_DUR;
    public static final ForgeConfigSpec.IntValue LAVA_CAKE_REGEN_DUR;
    public static final ForgeConfigSpec.IntValue LAVA_CAKE_STRENGTH_DUR;
    public static final ForgeConfigSpec.IntValue ICE_CAKE_NIGHT_VISION_DUR;
    public static final ForgeConfigSpec.IntValue CHORUS_CAKE_LEVITATION_DUR;
    public static final ForgeConfigSpec.IntValue GLOWSTONE_CAKE_GLOWING_DUR;
    public static final ForgeConfigSpec.IntValue POISON_CAKE_POISON_STRENGTH;
    public static final ForgeConfigSpec.IntValue GAPPLE_CAKE_REGEN_STRENGTH;
    public static final ForgeConfigSpec.IntValue GAPPLE_CAKE_RES_STRENGTH;
    public static final ForgeConfigSpec.IntValue GAPPLE_CAKE_ABSORPTION_STRENGTH;
    public static final ForgeConfigSpec.IntValue FIREY_CAKE_FIRE_RES_STRENGTH;
    public static final ForgeConfigSpec.IntValue SLIME_CAKE_JUMP_BOOST_STRENGTH;
    public static final ForgeConfigSpec.IntValue SLIME_CAKE_RES_STRENGTH;
    public static final ForgeConfigSpec.IntValue SLIME_CAKE_BOUNCING_STRENGTH;
    public static final ForgeConfigSpec.IntValue BEETROOT_CAKE_REGEN_STRENGTH;
    public static final ForgeConfigSpec.IntValue LAVA_CAKE_REGEN_STRENGTH;
    public static final ForgeConfigSpec.IntValue LAVA_CAKE_STRENGTH_STRENGTH;
    public static final ForgeConfigSpec.IntValue ICE_CAKE_NIGHT_VISION_STRENGTH;
    public static final ForgeConfigSpec.IntValue CHORUS_CAKE_LEVITATION_STRENGTH;
    public static final ForgeConfigSpec.DoubleValue CHORUS_CAKE_TELEPORT_RADIUS;
    public static final ForgeConfigSpec.DoubleValue ENDER_CAKE_TELEPORT_RADIUS;
    public static final ForgeConfigSpec.BooleanValue EFFECTED_BY_REDSTONE;
    public static final ForgeConfigSpec SERVERSPEC;

    private static ForgeConfigSpec.IntValue registerPotionDur(String field, int defaultInt) {
        return SERVER_BUILDER.defineInRange(field, defaultInt, 0, 32000);
    }

    private static ForgeConfigSpec.IntValue registerPotionStrength(String field, int defaultInt) {
        return SERVER_BUILDER.defineInRange(field, defaultInt, 0, 9);
    }

    static {
        SERVER_BUILDER.comment("Durations of the cake potion effects").push("Potion durations");
        POISON_CAKE_POISON_DUR = ModServerConfigs.registerPotionDur("poisonCakePoisonDur", 300);
        GAPPLE_CAKE_REGEN_DUR = ModServerConfigs.registerPotionDur("goldenAppleCakeRegenDur", 200);
        GAPPLE_CAKE_RES_DUR = ModServerConfigs.registerPotionDur("goldenAppleCakeResDur", 3000);
        GAPPLE_CAKE_ABSORPTION_DUR = ModServerConfigs.registerPotionDur("goldenAppleCakeAbsorptionDur", 1200);
        FIREY_CAKE_FIRE_RES_DUR = ModServerConfigs.registerPotionDur("fireyCakeFireResDur", 300);
        FIREY_CAKE_ON_FIRE_DUR = ModServerConfigs.registerPotionDur("fireyCakeOnFireDur", 20);
        SLIME_CAKE_JUMP_BOOST_DUR = ModServerConfigs.registerPotionDur("slimeCakeJumpBoostDur", 1200);
        SLIME_CAKE_RES_DUR = ModServerConfigs.registerPotionDur("slimeCakeResDur", 1200);
        SLIME_CAKE_BOUNCING_DUR = ModServerConfigs.registerPotionDur("slimeCakeBouncingDur", 1200);
        BEETROOT_CAKE_REGEN_DUR = ModServerConfigs.registerPotionDur("beetrootCakeRegenDur", 100);
        LAVA_CAKE_REGEN_DUR = ModServerConfigs.registerPotionDur("lavaCakeRegenDur", 300);
        LAVA_CAKE_STRENGTH_DUR = ModServerConfigs.registerPotionDur("lavaCakeStrengthDur", 300);
        ICE_CAKE_NIGHT_VISION_DUR = ModServerConfigs.registerPotionDur("iceCakeNightVisionDur", 2400);
        CHORUS_CAKE_LEVITATION_DUR = ModServerConfigs.registerPotionDur("chorusCakeLevitationDur", 300);
        GLOWSTONE_CAKE_GLOWING_DUR = ModServerConfigs.registerPotionDur("glowstoneCakeGlowingDur", 85);
        SERVER_BUILDER.pop();
        SERVER_BUILDER.comment("Strengths of the cake potion effects").push("Potion strengths");
        POISON_CAKE_POISON_STRENGTH = ModServerConfigs.registerPotionStrength("poisonCakePoisonStrength", 1);
        GAPPLE_CAKE_REGEN_STRENGTH = ModServerConfigs.registerPotionStrength("goldenAppleCakeRegenStrength", 1);
        GAPPLE_CAKE_RES_STRENGTH = ModServerConfigs.registerPotionStrength("goldenAppleCakeResStrength", 0);
        GAPPLE_CAKE_ABSORPTION_STRENGTH = ModServerConfigs.registerPotionStrength("goldenAppleCakeAbsorptionStrength", 1);
        FIREY_CAKE_FIRE_RES_STRENGTH = ModServerConfigs.registerPotionStrength("fireyCakeFireResStrength", 1);
        SLIME_CAKE_JUMP_BOOST_STRENGTH = ModServerConfigs.registerPotionStrength("slimeCakeJumpBoostStrength", 0);
        SLIME_CAKE_RES_STRENGTH = ModServerConfigs.registerPotionStrength("slimeCakeResStrength", 0);
        SLIME_CAKE_BOUNCING_STRENGTH = ModServerConfigs.registerPotionStrength("slimeCakeBouncingStrength", 0);
        BEETROOT_CAKE_REGEN_STRENGTH = ModServerConfigs.registerPotionStrength("beetrootCakeRegenStrength", 1);
        LAVA_CAKE_REGEN_STRENGTH = ModServerConfigs.registerPotionStrength("lavaCakeRegenStrength", 1);
        LAVA_CAKE_STRENGTH_STRENGTH = ModServerConfigs.registerPotionStrength("lavaCakeStrengthStrength", 1);
        ICE_CAKE_NIGHT_VISION_STRENGTH = ModServerConfigs.registerPotionStrength("iceCakeNightVisionStrength", 0);
        CHORUS_CAKE_LEVITATION_STRENGTH = ModServerConfigs.registerPotionStrength("chorusCakeLevitationStrength", 1);
        SERVER_BUILDER.pop();
        SERVER_BUILDER.comment("Miscellaneous configs").push("Misc");
        CHORUS_CAKE_TELEPORT_RADIUS = SERVER_BUILDER.comment("The radius in which the player will be randomly teleported").defineInRange("chorusCakeTeleportRadius", 10.0, 0.0, 10000.0);
        ENDER_CAKE_TELEPORT_RADIUS = SERVER_BUILDER.comment("The radius in which the player will be randomly teleported").defineInRange("enderCakeTeleportRadius", 50.0, 0.0, 10000.0);
        EFFECTED_BY_REDSTONE = SERVER_BUILDER.comment("Whether the TNT cake will explode when powered by Redstone").define("effectedByRedstone", false);
        SERVERSPEC = SERVER_BUILDER.build();
    }
}

