/*
 * Decompiled with CFR 0.152.
 */
package snownee.lightingwand.common;

import net.minecraft.block.Block;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import snownee.lightingwand.Config;
import snownee.lightingwand.client.EmptyEntityRenderer;
import snownee.lightingwand.common.LightBlock;
import snownee.lightingwand.common.LightEntity;
import snownee.lightingwand.common.ModConstants;
import snownee.lightingwand.common.RepairRecipe;
import snownee.lightingwand.common.RepairRecipeCondition;
import snownee.lightingwand.common.WandItem;
import snownee.lightingwand.compat.PsiCompat;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonRegistry {
    private static EntityType<LightEntity> ENTITY;
    public static boolean psiCompat;

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        event.getRegistry().register(new LightBlock().setRegistryName("lightingwand", "light"));
    }

    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        event.getRegistry().register(new WandItem().setRegistryName("lightingwand", "wand"));
        if (ModList.get().isLoaded("psi")) {
            psiCompat = true;
            PsiCompat.init();
        }
    }

    @SubscribeEvent
    public static void onEntityRegister(RegistryEvent.Register<EntityType<?>> event) {
        ENTITY = (EntityType)EntityType.Builder.func_220319_a((EntityClassification)EntityClassification.MISC).setCustomClientFactory((spawnEntity, world) -> new LightEntity((World)world)).func_220321_a(1.0E-4f, 1.0E-4f).func_220320_c().setTrackingRange(64).setUpdateInterval(20).setShouldReceiveVelocityUpdates(true).func_206830_a("lightingwand.light").setRegistryName("lightingwand", "light");
        event.getRegistry().register((IForgeRegistryEntry)ENTITY);
    }

    @SubscribeEvent
    public static void onRecipeRegister(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        event.getRegistry().register(new RepairRecipe.Serializer().setRegistryName("lightingwand", "repair"));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CraftingHelper.register((IConditionSerializer)new RepairRecipeCondition.Serializer());
        if (ModConstants.WAND != Items.field_190931_a) {
            if (((Boolean)Config.shootProjectile.get()).booleanValue()) {
                DispenserBlock.func_199774_a((IItemProvider)ModConstants.WAND, (IDispenseItemBehavior)new IDispenseItemBehavior(){

                    public ItemStack dispense(IBlockSource source, ItemStack stack) {
                        ServerWorld world = source.func_197524_h();
                        if (!world.field_72995_K && WandItem.isUsable(stack)) {
                            IPosition iposition = DispenserBlock.func_149939_a((IBlockSource)source);
                            Direction Direction2 = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
                            LightEntity entity = new LightEntity((World)world, iposition.func_82615_a(), iposition.func_82617_b(), iposition.func_82616_c());
                            entity.func_70186_c(Direction2.func_82601_c(), (float)Direction2.func_96559_d() + 0.1f, Direction2.func_82599_e(), 1.3f + world.field_73012_v.nextFloat() * 0.4f, 0.0f);
                            Vector3d motion = entity.func_213322_ci();
                            entity.func_213317_d(motion.func_72441_c(world.field_73012_v.nextGaussian() * 0.1, 0.0, world.field_73012_v.nextGaussian() * 0.1));
                            world.func_217376_c((Entity)entity);
                            stack.func_96631_a(1, world.field_73012_v, null);
                        }
                        return stack;
                    }
                });
            }
            ModConstants.WAND.field_77699_b = (Integer)Config.wandDurability.get();
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void clientInit(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(ENTITY, EmptyEntityRenderer::new);
        ItemModelsProperties.func_239418_a_((Item)ModConstants.WAND, (ResourceLocation)new ResourceLocation("broken"), (stack, worldIn, entityIn) -> WandItem.isUsable(stack) ? 0.0f : 1.0f);
    }

    static {
        psiCompat = false;
    }
}

