/*
 * Decompiled with CFR 0.152.
 */
package snownee.lightingwand.common;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import snownee.lightingwand.Config;
import snownee.lightingwand.common.EnergyRepair;
import snownee.lightingwand.common.LightBlock;
import snownee.lightingwand.common.LightEntity;
import snownee.lightingwand.common.ModConstants;

public class WandItem
extends Item {
    public WandItem() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78040_i).setNoRepair().func_200917_a(1));
    }

    public static boolean isUsable(ItemStack stack) {
        return stack.func_77952_i() < stack.func_77958_k();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (WandItem.isUsable(stack)) {
            BlockRayTraceResult rayTraceResult = WandItem.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
            if (rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockRayTraceResult blockRayTraceResult = rayTraceResult;
                BlockPos pos = blockRayTraceResult.func_216350_a().func_177972_a(blockRayTraceResult.func_216354_b());
                if (!playerIn.func_175151_a(pos, playerIn.func_184172_bi(), stack)) {
                    return new ActionResult(ActionResultType.FAIL, (Object)playerIn.func_184586_b(handIn));
                }
                BlockState state = worldIn.func_180495_p(pos);
                if (state.func_177230_c() != ModConstants.LIGHT && state.func_185904_a().func_76222_j()) {
                    if (!playerIn.func_184812_l_()) {
                        stack.func_196085_b(stack.func_77952_i() + 1);
                    }
                    worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187884_fr, SoundCategory.BLOCKS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
                    if (!worldIn.field_72995_K) {
                        FluidState fluidstate = worldIn.func_204610_c(pos);
                        worldIn.func_180501_a(pos, (BlockState)ModConstants.LIGHT.func_176223_P().func_206870_a((Property)LightBlock.WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206884_a((ITag)FluidTags.field_206959_a) && fluidstate.func_206882_g() == 8)), 11);
                    }
                }
            } else if (rayTraceResult.func_216346_c() == RayTraceResult.Type.MISS && ((Boolean)Config.shootProjectile.get()).booleanValue()) {
                worldIn.func_184148_a((PlayerEntity)null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187511_aA, SoundCategory.PLAYERS, 0.8f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                ItemStack held = playerIn.func_184586_b(handIn);
                if (!worldIn.field_72995_K) {
                    LightEntity entity = new LightEntity(worldIn, (LivingEntity)playerIn);
                    entity.func_234612_a_((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, 1.5f, 0.0f);
                    worldIn.func_217376_c((Entity)entity);
                }
                if (!playerIn.func_184812_l_()) {
                    held.func_196085_b(held.func_77952_i() + 1);
                }
            }
            if (!WandItem.isUsable(stack)) {
                worldIn.func_184148_a((PlayerEntity)null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187635_cQ, SoundCategory.NEUTRAL, 0.5f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
            }
            playerIn.func_184609_a(handIn);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!WandItem.isUsable(stack)) {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_RED + "" + TextFormatting.BOLD + I18n.func_135052_a((String)"tip.lightingwand.uncharged", (Object[])new Object[0])));
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        if (!WandItem.isUsable(stack)) {
            return false;
        }
        return super.showDurabilityBar(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (WandItem.isUsable(stack)) {
            target.func_195064_c(new EffectInstance(Effects.field_188423_x, 200));
            if (attacker instanceof PlayerEntity && !((PlayerEntity)attacker).func_184812_l_()) {
                stack.func_196085_b(stack.func_77952_i() + 1);
            }
            return true;
        }
        return super.func_77644_a(stack, target, attacker);
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundNBT nbt) {
        return new ICapabilityProvider(){
            private final LazyOptional<EnergyRepair> handler = LazyOptional.of(() -> new EnergyRepair(stack));

            public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
                if (cap == CapabilityEnergy.ENERGY && (Integer)Config.energyPerUse.get() > 0) {
                    return this.handler.cast();
                }
                return LazyOptional.empty();
            }
        };
    }
}

