/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.blocks;

import com.tomboshoven.minecraft.magicdoorknob.blocks.Blocks;
import com.tomboshoven.minecraft.magicdoorknob.blocks.MagicDoorwayPartBaseBlock;
import com.tomboshoven.minecraft.magicdoorknob.blocks.tileentities.MagicDoorTileEntity;
import com.tomboshoven.minecraft.magicdoorknob.blocks.tileentities.MagicDoorwayPartBaseTileEntity;
import com.tomboshoven.minecraft.magicdoorknob.items.MagicDoorknobItem;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MagicDoorBlock
extends MagicDoorwayPartBaseBlock {
    public static final EnumProperty<MagicDoorwayPartBaseBlock.EnumPartType> PART = EnumProperty.func_177709_a((String)"part", MagicDoorwayPartBaseBlock.EnumPartType.class);
    public static final EnumProperty<Direction> HORIZONTAL_FACING = BlockStateProperties.field_208157_J;
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0)};
    private static final int DOORWAY_BREAK_MAX_DEPTH = 32;

    MagicDoorBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    @Override
    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof MagicDoorTileEntity) {
            BlockState textureBlock = ((MagicDoorwayPartBaseTileEntity)tileEntity).getBaseBlockState();
            SoundType actualSoundType = textureBlock.func_177230_c().getSoundType(textureBlock, world, pos, null);
            return new SoundType(actualSoundType.field_185860_m, actualSoundType.field_185861_n, SoundEvents.field_187873_gM, actualSoundType.func_185844_d(), SoundEvents.field_187875_gN, actualSoundType.func_185846_f(), actualSoundType.func_185842_g());
        }
        return super.getSoundType(state, world, pos, entity);
    }

    @Nullable
    private static MagicDoorknobItem getDoorknob(IBlockReader world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof MagicDoorTileEntity) {
            return ((MagicDoorwayPartBaseTileEntity)tileEntity).getDoorknob();
        }
        return null;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        MagicDoorBlock.breakDoorway(worldIn, pos, (Direction)state.func_177229_b(HORIZONTAL_FACING));
        if (state.func_177229_b(PART) == MagicDoorwayPartBaseBlock.EnumPartType.TOP) {
            MagicDoorknobItem doorknob = MagicDoorBlock.getDoorknob((IBlockReader)worldIn, pos);
            if (doorknob != null) {
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)new ItemStack((IItemProvider)doorknob, 1));
            }
            worldIn.func_175655_b(pos.func_177977_b(), false);
        } else {
            worldIn.func_175655_b(pos.func_177984_a(), false);
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    private static void breakDoorway(World world, BlockPos pos, Direction facing) {
        Direction doorwayFacing = facing.func_176734_d();
        MagicDoorknobItem doorknob = MagicDoorBlock.getDoorknob((IBlockReader)world, pos);
        float depth = doorknob == null ? 32.0f : doorknob.getTier().func_200928_b();
        int i = 1;
        while ((float)i <= depth) {
            BlockPos blockPos = pos.func_177967_a(doorwayFacing, i);
            BlockState state = world.func_180495_p(blockPos);
            if (state.func_177230_c() == Blocks.MAGIC_DOORWAY.get()) {
                world.func_175655_b(blockPos, false);
            }
            ++i;
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[((Direction)state.func_177229_b(HORIZONTAL_FACING)).func_176736_b()];
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PART, HORIZONTAL_FACING});
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new MagicDoorTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            worldIn.func_175655_b(pos, false);
        }
        return ActionResultType.SUCCESS;
    }
}

