/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.blocks;

import com.tomboshoven.minecraft.magicdoorknob.blocks.MagicDoorwayPartBaseBlock;
import com.tomboshoven.minecraft.magicdoorknob.blocks.tileentities.MagicDoorwayPartBaseTileEntity;
import com.tomboshoven.minecraft.magicdoorknob.blocks.tileentities.MagicDoorwayTileEntity;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MagicDoorwayBlock
extends MagicDoorwayPartBaseBlock {
    public static final EnumProperty<MagicDoorwayPartBaseBlock.EnumPartType> PART = EnumProperty.func_177709_a((String)"part", MagicDoorwayPartBaseBlock.EnumPartType.class);
    public static final BooleanProperty OPEN_NORTH_SOUTH = BooleanProperty.func_177716_a((String)"open_north_south");
    public static final BooleanProperty OPEN_EAST_WEST = BooleanProperty.func_177716_a((String)"open_east_west");
    private static final VoxelShape BOUNDING_BOX_PILLAR_NW = MagicDoorwayBlock.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape BOUNDING_BOX_PILLAR_NE = MagicDoorwayBlock.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0);
    private static final VoxelShape BOUNDING_BOX_PILLAR_SW = MagicDoorwayBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0);
    private static final VoxelShape BOUNDING_BOX_PILLAR_SE = MagicDoorwayBlock.func_208617_a((double)15.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape BOUNDING_BOX_WALL_S = MagicDoorwayBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape BOUNDING_BOX_WALL_N = MagicDoorwayBlock.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape BOUNDING_BOX_WALL_E = MagicDoorwayBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape BOUNDING_BOX_WALL_W = MagicDoorwayBlock.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape BOUNDING_BOX_TOP = MagicDoorwayBlock.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    MagicDoorwayBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(PART, (Comparable)((Object)MagicDoorwayPartBaseBlock.EnumPartType.BOTTOM))).func_206870_a((Property)OPEN_EAST_WEST, (Comparable)Boolean.TRUE)).func_206870_a((Property)OPEN_NORTH_SOUTH, (Comparable)Boolean.FALSE));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        boolean openNorthSouth = (Boolean)state.func_177229_b((Property)OPEN_NORTH_SOUTH);
        boolean openEastWest = (Boolean)state.func_177229_b((Property)OPEN_EAST_WEST);
        boolean isTop = state.func_177229_b(PART) == MagicDoorwayPartBaseBlock.EnumPartType.TOP;
        VoxelShape result = VoxelShapes.func_197880_a();
        if (openNorthSouth && openEastWest) {
            result = VoxelShapes.func_216384_a((VoxelShape)result, (VoxelShape[])new VoxelShape[]{BOUNDING_BOX_PILLAR_NE, BOUNDING_BOX_PILLAR_NW, BOUNDING_BOX_PILLAR_SE, BOUNDING_BOX_PILLAR_SW});
        } else {
            if (!openNorthSouth) {
                result = VoxelShapes.func_216384_a((VoxelShape)result, (VoxelShape[])new VoxelShape[]{BOUNDING_BOX_WALL_N, BOUNDING_BOX_WALL_S});
            }
            if (!openEastWest) {
                result = VoxelShapes.func_216384_a((VoxelShape)result, (VoxelShape[])new VoxelShape[]{BOUNDING_BOX_WALL_E, BOUNDING_BOX_WALL_W});
            }
        }
        if (isTop) {
            result = VoxelShapes.func_197872_a((VoxelShape)result, (VoxelShape)BOUNDING_BOX_TOP);
        }
        return result;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileEntity;
        if (newState.isAir((IBlockReader)worldIn, pos) && (tileEntity = worldIn.func_175625_s(pos)) instanceof MagicDoorwayTileEntity) {
            worldIn.func_175656_a(pos, ((MagicDoorwayPartBaseTileEntity)tileEntity).getBaseBlockState());
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PART, OPEN_NORTH_SOUTH, OPEN_EAST_WEST});
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new MagicDoorwayTileEntity();
    }
}

