/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.blocks;

import com.tomboshoven.minecraft.magicdoorknob.blocks.tileentities.MagicDoorwayPartBaseTileEntity;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class MagicDoorwayPartBaseBlock
extends Block {
    MagicDoorwayPartBaseBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        return true;
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof MagicDoorwayPartBaseTileEntity) {
            BlockState baseBlock = ((MagicDoorwayPartBaseTileEntity)tileEntity).getBaseBlockState();
            return baseBlock.func_177230_c().getSoundType(baseBlock, world, pos, null);
        }
        return super.getSoundType(state, world, pos, entity);
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof MagicDoorwayPartBaseTileEntity) {
            return ((MagicDoorwayPartBaseTileEntity)tileEntity).getBaseBlockState().getLightValue(world, pos);
        }
        return super.getLightValue(state, world, pos);
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof MagicDoorwayPartBaseTileEntity) {
            return ((MagicDoorwayPartBaseTileEntity)tileEntity).getBaseBlockState().func_200016_a(worldIn, pos);
        }
        return super.func_200011_d(state, worldIn, pos);
    }

    public float getSlipperiness(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof MagicDoorwayPartBaseTileEntity) {
            return ((MagicDoorwayPartBaseTileEntity)tileEntity).getBaseBlockState().getSlipperiness(world, pos, entity);
        }
        return super.getSlipperiness(state, world, pos, entity);
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof MagicDoorwayPartBaseTileEntity) {
            return ((MagicDoorwayPartBaseTileEntity)tileEntity).getBaseBlockState().func_185903_a(player, worldIn, pos);
        }
        return super.func_180647_a(state, player, worldIn, pos);
    }

    public int getHarvestLevel(BlockState state) {
        return -1;
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return null;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public static enum EnumPartType implements IStringSerializable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private EnumPartType(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

