/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.blocks.tileentities;

import com.tomboshoven.minecraft.magicdoorknob.items.Items;
import com.tomboshoven.minecraft.magicdoorknob.items.MagicDoorknobItem;
import com.tomboshoven.minecraft.magicdoorknob.modelloaders.textured.ModelTextureProperty;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class MagicDoorwayPartBaseTileEntity
extends TileEntity {
    private static final ModelTextureProperty TEXTURE_MAIN = ModelTextureProperty.get(new ResourceLocation("property", "texture_main"));
    private static final ModelTextureProperty TEXTURE_HIGHLIGHT = ModelTextureProperty.get(new ResourceLocation("property", "texture_highlight"));
    private BlockState baseBlockState = Blocks.field_150350_a.func_176223_P();
    private MagicDoorknobItem doorknob;

    MagicDoorwayPartBaseTileEntity(TileEntityType<? extends MagicDoorwayPartBaseTileEntity> tileEntityType) {
        super(tileEntityType);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        return this.writeInternal(compound);
    }

    private CompoundNBT writeInternal(CompoundNBT compound) {
        CompoundNBT result = super.func_189515_b(compound);
        ResourceLocation registryName = this.baseBlockState.func_177230_c().getRegistryName();
        if (registryName != null) {
            compound.func_218657_a("baseBlock", (INBT)NBTUtil.func_190009_a((BlockState)this.baseBlockState));
        }
        if (this.doorknob != null) {
            result.func_74778_a("doorknobType", this.doorknob.getTypeName());
        }
        return result;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.readInternal(compound);
    }

    private void readInternal(CompoundNBT compound) {
        this.baseBlockState = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("baseBlock"));
        String doorknobType = compound.func_74779_i("doorknobType");
        this.doorknob = Items.DOORKNOBS.get(doorknobType);
    }

    public CompoundNBT func_189517_E_() {
        return this.writeInternal(super.func_189517_E_());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, this.func_189517_E_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.readInternal(pkt.func_148857_g());
        this.requestModelDataUpdate();
    }

    @OnlyIn(value=Dist.CLIENT)
    public IModelData getModelData() {
        Minecraft minecraft = Minecraft.func_71410_x();
        BlockModelShapes blockModelShapes = minecraft.func_175602_ab().func_175023_a();
        World world = this.func_145831_w();
        TextureAtlasSprite blockTexture = world == null ? null : blockModelShapes.getTexture(this.baseBlockState, world, this.func_174877_v());
        RenderMaterial blockMaterial = blockTexture == null || blockTexture instanceof MissingTextureSprite ? new RenderMaterial(PlayerContainer.field_226615_c_, new ResourceLocation("magic_doorknob", "block/empty")) : new RenderMaterial(blockTexture.func_229241_m_().func_229223_g_(), blockTexture.func_195668_m());
        RenderMaterial doorknobMaterial = this.doorknob != null ? this.doorknob.getMainMaterial() : blockMaterial;
        CompositeModel.CompositeModelData compositeModelData = new CompositeModel.CompositeModelData();
        compositeModelData.setData((ModelProperty)TEXTURE_MAIN, (Object)blockMaterial);
        compositeModelData.setData((ModelProperty)TEXTURE_HIGHLIGHT, (Object)doorknobMaterial);
        return compositeModelData;
    }

    public BlockState getBaseBlockState() {
        return this.baseBlockState;
    }

    public void setBaseBlockState(BlockState baseBlockState) {
        this.baseBlockState = baseBlockState;
    }

    @Nullable
    public MagicDoorknobItem getDoorknob() {
        return this.doorknob;
    }

    public void setDoorknob(MagicDoorknobItem doorknob) {
        this.doorknob = doorknob;
    }
}

