/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.data;

import com.tomboshoven.minecraft.magicdoorknob.blocks.Blocks;
import com.tomboshoven.minecraft.magicdoorknob.items.Items;
import com.tomboshoven.minecraft.magicdoorknob.items.MagicDoorknobItem;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraftforge.common.data.LanguageProvider;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
class Language
extends LanguageProvider {
    Language(DataGenerator gen) {
        super(gen, "magic_doorknob", "en_us");
    }

    protected void addTranslations() {
        this.add((Block)Blocks.MAGIC_DOOR.get(), "Magic Door");
        this.add((Block)Blocks.MAGIC_DOORWAY.get(), "Magic Doorway");
        this.addDoorknob("diamond");
        this.addDoorknob("gold", "Golden");
        this.addDoorknob("iron");
        this.addDoorknob("netherite");
        this.addDoorknob("stone");
        this.addDoorknob("wood", "Wooden");
    }

    private void addDoorknob(String typeName) {
        this.addDoorknob(typeName, StringUtils.capitalize((String)typeName));
    }

    private void addDoorknob(String typeName, String materialName) {
        MagicDoorknobItem doorknob = Items.DOORKNOBS.get(typeName);
        this.add(doorknob, String.format("%s Magic Doorknob", materialName));
    }

    @Nonnull
    public String func_200397_b() {
        return String.format("%s %s", "magic_doorknob", super.func_200397_b());
    }
}

