/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.items;

import com.google.common.collect.Maps;
import com.tomboshoven.minecraft.magicdoorknob.items.MagicDoorknobItem;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemTier;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class Items {
    public static final Map<String, MagicDoorknobItem> DOORKNOBS = Maps.newHashMap();

    private Items() {
    }

    private static void addDoorknob(IForgeRegistry<? super Item> registry, String typeName, IItemTier tier, ResourceLocation mainTexture, Supplier<Ingredient> ingredient) {
        MagicDoorknobItem i = new MagicDoorknobItem(new Item.Properties().func_200916_a(ItemGroup.field_78040_i), typeName, tier, mainTexture, ingredient);
        i.setRegistryName("magic_doorknob", String.format("magic_doorknob_%s", typeName));
        registry.register((IForgeRegistryEntry)i);
        DOORKNOBS.put(typeName, i);
    }

    private static void addDoorknob(IForgeRegistry<? super Item> registry, String typeName, IItemTier tier, String blockName, Supplier<Ingredient> ingredient) {
        Items.addDoorknob(registry, typeName, tier, new ResourceLocation("minecraft", String.format("block/%s", blockName)), ingredient);
    }

    public static void register(IEventBus eventBus) {
        eventBus.addGenericListener(Item.class, Items::registerItems);
    }

    private static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        Items.addDoorknob((IForgeRegistry<? super Item>)registry, "wood", (IItemTier)ItemTier.WOOD, "oak_planks", () -> Ingredient.func_199805_a((ITag)ItemTags.field_199905_b));
        Items.addDoorknob((IForgeRegistry<? super Item>)registry, "stone", (IItemTier)ItemTier.STONE, "stone", () -> Ingredient.func_199805_a((ITag)Tags.Items.COBBLESTONE));
        Items.addDoorknob((IForgeRegistry<? super Item>)registry, "iron", (IItemTier)ItemTier.IRON, "iron_block", () -> Ingredient.func_199805_a((ITag)Tags.Items.INGOTS_IRON));
        Items.addDoorknob((IForgeRegistry<? super Item>)registry, "gold", (IItemTier)ItemTier.GOLD, "gold_block", () -> Ingredient.func_199805_a((ITag)Tags.Items.INGOTS_GOLD));
        Items.addDoorknob((IForgeRegistry<? super Item>)registry, "diamond", (IItemTier)ItemTier.DIAMOND, "diamond_block", () -> Ingredient.func_199805_a((ITag)Tags.Items.GEMS_DIAMOND));
        Items.addDoorknob((IForgeRegistry<? super Item>)registry, "netherite", (IItemTier)ItemTier.NETHERITE, "netherite_block", () -> Ingredient.func_199805_a((ITag)Tags.Items.INGOTS_NETHERITE));
    }
}

