/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.items;

import com.tomboshoven.minecraft.magicdoorknob.blocks.Blocks;
import com.tomboshoven.minecraft.magicdoorknob.blocks.MagicDoorBlock;
import com.tomboshoven.minecraft.magicdoorknob.blocks.MagicDoorwayBlock;
import com.tomboshoven.minecraft.magicdoorknob.blocks.MagicDoorwayPartBaseBlock;
import com.tomboshoven.minecraft.magicdoorknob.blocks.tileentities.MagicDoorTileEntity;
import com.tomboshoven.minecraft.magicdoorknob.blocks.tileentities.MagicDoorwayPartBaseTileEntity;
import com.tomboshoven.minecraft.magicdoorknob.blocks.tileentities.MagicDoorwayTileEntity;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MagicDoorknobItem
extends Item {
    private final ResourceLocation mainTextureLocation;
    private final String typeName;
    private final IItemTier tier;
    private final Supplier<Ingredient> ingredient;

    MagicDoorknobItem(Item.Properties properties, String typeName, IItemTier tier, ResourceLocation mainTextureLocation, Supplier<Ingredient> ingredient) {
        super(properties);
        this.typeName = typeName;
        this.tier = tier;
        this.mainTextureLocation = mainTextureLocation;
        this.ingredient = ingredient;
    }

    private static boolean isEmpty(IBlockReader world, BlockPos pos, BlockItemUseContext useContext) {
        BlockState blockState = world.func_180495_p(pos);
        if (blockState.func_177230_c().isAir(blockState, world, pos)) {
            return true;
        }
        return blockState.func_196953_a(useContext);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        if (!world.field_72995_K) {
            Direction face = context.func_196000_l();
            BlockPos pos = context.func_195995_a();
            if (face == Direction.UP || face == Direction.DOWN) {
                return ActionResultType.FAIL;
            }
            BlockItemUseContext useContext = new BlockItemUseContext(context);
            if (this.canPlaceDoor((IBlockReader)world, pos, face, useContext)) {
                this.placeDoor(world, pos, face);
                this.placeDoorway(world, pos, face, useContext);
                context.func_195996_i().func_190918_g(1);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.FAIL;
        }
        return ActionResultType.SUCCESS;
    }

    private void placeDoor(World world, BlockPos pos, Direction facing) {
        BlockPos doorPos = pos.func_177972_a(facing);
        Block block = (Block)Blocks.MAGIC_DOOR.get();
        world.func_175656_a(doorPos, (BlockState)((BlockState)block.func_176223_P().func_206870_a(MagicDoorBlock.HORIZONTAL_FACING, (Comparable)facing)).func_206870_a(MagicDoorBlock.PART, (Comparable)((Object)MagicDoorwayPartBaseBlock.EnumPartType.TOP)));
        TileEntity topTileEntity = world.func_175625_s(doorPos);
        if (topTileEntity instanceof MagicDoorTileEntity) {
            ((MagicDoorwayPartBaseTileEntity)topTileEntity).setBaseBlockState(world.func_180495_p(pos));
            ((MagicDoorwayPartBaseTileEntity)topTileEntity).setDoorknob(this);
        }
        world.func_175656_a(doorPos.func_177977_b(), (BlockState)((BlockState)block.func_176223_P().func_206870_a(MagicDoorBlock.HORIZONTAL_FACING, (Comparable)facing)).func_206870_a(MagicDoorBlock.PART, (Comparable)((Object)MagicDoorwayPartBaseBlock.EnumPartType.BOTTOM)));
        TileEntity bottomTileEntity = world.func_175625_s(doorPos.func_177977_b());
        if (bottomTileEntity instanceof MagicDoorTileEntity) {
            ((MagicDoorwayPartBaseTileEntity)bottomTileEntity).setBaseBlockState(world.func_180495_p(pos.func_177977_b()));
            ((MagicDoorwayPartBaseTileEntity)bottomTileEntity).setDoorknob(this);
        }
        world.func_184133_a(null, doorPos, SoundEvents.field_187875_gN, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    private void placeDoorway(World world, BlockPos pos, Direction facing, BlockItemUseContext useContext) {
        BlockPos elementPos;
        Direction doorwayFacing = facing.func_176734_d();
        boolean isNorthSouth = facing == Direction.NORTH || facing == Direction.SOUTH;
        float depth = this.tier.func_200928_b();
        int i = 0;
        while ((float)i < depth && (this.isReplaceable((IBlockReader)world, elementPos = pos.func_177967_a(doorwayFacing, i)) && !MagicDoorknobItem.isEmpty((IBlockReader)world, elementPos, useContext) || this.isReplaceable((IBlockReader)world, elementPos.func_177977_b()) && !MagicDoorknobItem.isEmpty((IBlockReader)world, elementPos.func_177977_b(), useContext))) {
            this.placeDoorwayElement(world, elementPos, isNorthSouth, MagicDoorwayPartBaseBlock.EnumPartType.TOP);
            this.placeDoorwayElement(world, elementPos.func_177977_b(), isNorthSouth, MagicDoorwayPartBaseBlock.EnumPartType.BOTTOM);
            ++i;
        }
    }

    private void placeDoorwayElement(World world, BlockPos pos, boolean isNorthSouth, MagicDoorwayPartBaseBlock.EnumPartType part) {
        if (this.isReplaceable((IBlockReader)world, pos)) {
            BlockState state = world.func_180495_p(pos);
            Block block = (Block)Blocks.MAGIC_DOORWAY.get();
            world.func_175656_a(pos, (BlockState)((BlockState)((BlockState)block.func_176223_P().func_206870_a((Property)MagicDoorwayBlock.OPEN_NORTH_SOUTH, (Comparable)Boolean.valueOf(isNorthSouth))).func_206870_a((Property)MagicDoorwayBlock.OPEN_EAST_WEST, (Comparable)Boolean.valueOf(!isNorthSouth))).func_206870_a(MagicDoorwayBlock.PART, (Comparable)((Object)part)));
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof MagicDoorwayTileEntity) {
                ((MagicDoorwayPartBaseTileEntity)tileEntity).setBaseBlockState(state);
                ((MagicDoorwayPartBaseTileEntity)tileEntity).setDoorknob(this);
            }
        }
    }

    private boolean canPlaceDoor(IBlockReader world, BlockPos pos, Direction facing, BlockItemUseContext useContext) {
        if (!this.isReplaceable(world, pos) || !this.isReplaceable(world, pos.func_177977_b())) {
            return false;
        }
        return MagicDoorknobItem.isEmpty(world, pos.func_177972_a(facing), useContext) && MagicDoorknobItem.isEmpty(world, pos.func_177972_a(facing).func_177977_b(), useContext);
    }

    private boolean isReplaceable(IBlockReader world, BlockPos pos) {
        BlockState blockState = world.func_180495_p(pos);
        if (blockState.hasTileEntity()) {
            return false;
        }
        if (blockState.func_185887_b(world, pos) < 0.0f) {
            return false;
        }
        return blockState.getHarvestLevel() <= this.tier.func_200925_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    public RenderMaterial getMainMaterial() {
        return new RenderMaterial(PlayerContainer.field_226615_c_, this.mainTextureLocation);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public IItemTier getTier() {
        return this.tier;
    }

    public Ingredient getIngredient() {
        return this.ingredient.get();
    }
}

