/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.modelloaders.textured;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.ModelProperty;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class ModelTextureProperty
extends ModelProperty<RenderMaterial> {
    private static final Map<ResourceLocation, ModelTextureProperty> PROPERTIES = Maps.newHashMap();
    private final ResourceLocation name;

    private ModelTextureProperty(ResourceLocation name) {
        this.name = name;
    }

    public static ModelTextureProperty get(ResourceLocation name) {
        return PROPERTIES.computeIfAbsent(name, ModelTextureProperty::new);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ModelTextureProperty that = (ModelTextureProperty)((Object)o);
        return this.name.equals((Object)that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

