/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.modelloaders.textured;

import com.google.common.collect.ImmutableList;
import com.tomboshoven.minecraft.magicdoorknob.modelloaders.textured.IItemStackTextureMapperProvider;
import com.tomboshoven.minecraft.magicdoorknob.modelloaders.textured.ITextureMapper;
import com.tomboshoven.minecraft.magicdoorknob.modelloaders.textured.PropertySprite;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverride;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
class TexturedBakedModel<T extends IBakedModel>
extends BakedModelWrapper<T> {
    private final Function<? super RenderMaterial, ? extends TextureAtlasSprite> bakedTextureGetter;
    private final ITextureMapper textureMapper;
    private static final VertexFormat VERTEX_FORMAT;
    private static final VertexFormatElement VERTEX_FORMAT_ELEMENT_UV;
    private static final int VERTEX_FORMAT_ELEMENT_UV_OFFSET;

    TexturedBakedModel(T originalModel, Function<? super RenderMaterial, ? extends TextureAtlasSprite> bakedTextureGetter, ITextureMapper textureMapper) {
        super(originalModel);
        this.bakedTextureGetter = bakedTextureGetter;
        this.textureMapper = textureMapper;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData) {
        List quads = this.originalModel.getQuads(state, side, rand, extraData);
        return quads.stream().map(quad -> {
            TextureAtlasSprite sprite = quad.func_187508_a();
            if (sprite instanceof PropertySprite) {
                RenderMaterial material = this.textureMapper.mapSprite((PropertySprite)sprite, state, extraData);
                TextureAtlasSprite actualSprite = this.bakedTextureGetter.apply((RenderMaterial)material);
                return TexturedBakedModel.retexture(quad, actualSprite);
            }
            return quad;
        }).collect(Collectors.toList());
    }

    private static BakedQuad retexture(BakedQuad quad, TextureAtlasSprite sprite) {
        int[] vertexData = (int[])quad.func_178209_a().clone();
        int stride = VERTEX_FORMAT.func_177338_f();
        int eltOffset = VERTEX_FORMAT_ELEMENT_UV.func_177367_b().func_177395_a();
        float minU = sprite.func_94209_e();
        float maxU = sprite.func_94212_f();
        float uDiff = maxU - minU;
        float minV = sprite.func_94206_g();
        float maxV = sprite.func_94210_h();
        float vDiff = maxV - minV;
        int idx = VERTEX_FORMAT_ELEMENT_UV_OFFSET;
        for (int vertex = 0; vertex < 4; ++vertex) {
            float vertexU = Float.intBitsToFloat(TexturedBakedModel.getAtByteOffset(vertexData, idx));
            float vertexV = Float.intBitsToFloat(TexturedBakedModel.getAtByteOffset(vertexData, idx + eltOffset));
            TexturedBakedModel.putAtByteOffset(vertexData, idx, Float.floatToRawIntBits(minU + uDiff * vertexU));
            TexturedBakedModel.putAtByteOffset(vertexData, idx + eltOffset, Float.floatToRawIntBits(minV + vDiff * vertexV));
            idx += stride;
        }
        return new BakedQuad(vertexData, quad.func_178211_c(), quad.func_178210_d(), sprite, quad.func_239287_f_());
    }

    private static int getAtByteOffset(int[] inData, int offset) {
        int index = offset / 4;
        int lsb = inData[index];
        int shift = offset % 4 * 8;
        if (shift == 0) {
            return inData[index];
        }
        int msb = inData[index + 1];
        return lsb >>> shift | msb << 32 - shift;
    }

    private static void putAtByteOffset(int[] outData, int offset, int value) {
        int index = offset / 4;
        int shift = offset % 4 * 8;
        if (shift == 0) {
            outData[index] = value;
            return;
        }
        int lsbMask = -1 >>> 32 - shift;
        int msbMask = -1 << shift;
        outData[index] = outData[index] & lsbMask | value << shift;
        outData[index + 1] = outData[index + 1] & msbMask | value >>> 32 - shift;
    }

    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        return this.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    public ItemOverrideList func_188617_f() {
        return new TexturedOverrideList(super.func_188617_f());
    }

    public TextureAtlasSprite getParticleTexture(@Nonnull IModelData data) {
        TextureAtlasSprite sprite = super.getParticleTexture(data);
        if (sprite instanceof PropertySprite) {
            RenderMaterial spriteLocation = this.textureMapper.mapSprite((PropertySprite)sprite, null, data);
            sprite = this.bakedTextureGetter.apply((RenderMaterial)spriteLocation);
        }
        return sprite;
    }

    static {
        int index;
        VERTEX_FORMAT = DefaultVertexFormats.field_176600_a;
        VertexFormatElement element = null;
        ImmutableList elements = VERTEX_FORMAT.func_227894_c_();
        int size = elements.size();
        for (index = 0; index < size; ++index) {
            VertexFormatElement el = (VertexFormatElement)VERTEX_FORMAT.func_227894_c_().get(index);
            if (el.func_177375_c() != VertexFormatElement.Usage.UV || el.func_177369_e() != 0) continue;
            element = el;
            break;
        }
        VERTEX_FORMAT_ELEMENT_UV = element;
        VERTEX_FORMAT_ELEMENT_UV_OFFSET = VERTEX_FORMAT.getOffset(index);
    }

    private class TexturedOverrideList
    extends ItemOverrideList {
        private final ItemOverrideList wrappedOverrideList;

        TexturedOverrideList(ItemOverrideList wrappedOverrideList) {
            this.wrappedOverrideList = wrappedOverrideList;
        }

        public ImmutableList<ItemOverride> getOverrides() {
            return this.wrappedOverrideList.getOverrides();
        }

        public IBakedModel func_239290_a_(IBakedModel model, ItemStack stack, @Nullable ClientWorld worldIn, @Nullable LivingEntity entityIn) {
            Item item = stack.func_77973_b();
            if (item instanceof IItemStackTextureMapperProvider) {
                return new TexturedBakedModel<IBakedModel>(model, TexturedBakedModel.this.bakedTextureGetter, ((IItemStackTextureMapperProvider)item).getTextureMapper(stack));
            }
            return this.wrappedOverrideList.func_239290_a_(model, stack, worldIn, entityIn);
        }
    }
}

