/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.modelloaders.textured;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.tomboshoven.minecraft.magicdoorknob.modelloaders.textured.ModelDataTextureMapper;
import com.tomboshoven.minecraft.magicdoorknob.modelloaders.textured.PropertySprite;
import com.tomboshoven.minecraft.magicdoorknob.modelloaders.textured.TexturedBakedModel;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.geometry.IModelGeometry;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
class TexturedModelGeometry
implements IModelGeometry<TexturedModelGeometry> {
    private final Set<? extends RenderMaterial> extraTextures;
    private final IModelGeometry<?> originalModelGeometry;

    TexturedModelGeometry(IModelGeometry<?> originalModelGeometry, Set<? extends RenderMaterial> extraTextures) {
        this.originalModelGeometry = originalModelGeometry;
        this.extraTextures = extraTextures;
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        Set textures = this.originalModelGeometry.getTextures(owner, modelGetter, missingTextureErrors).stream().filter(location -> !"property".equals(location.func_229313_b_().func_110624_b())).collect(Collectors.toSet());
        return Sets.union(textures, this.extraTextures);
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        Function<RenderMaterial, TextureAtlasSprite> augmentedSpriteGetter = material -> {
            if ("property".equals(material.func_229313_b_().func_110624_b())) {
                return new PropertySprite(material.func_229313_b_());
            }
            return (TextureAtlasSprite)spriteGetter.apply((RenderMaterial)material);
        };
        return new TexturedBakedModel<IBakedModel>(this.originalModelGeometry.bake(owner, bakery, augmentedSpriteGetter, modelTransform, overrides, modelLocation), spriteGetter, new ModelDataTextureMapper());
    }
}

