/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.modelloaders.textured;

import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.tomboshoven.minecraft.magicdoorknob.modelloaders.textured.TexturedModelGeometry;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.geometry.IModelGeometry;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class TexturedModelLoader
implements IModelLoader<TexturedModelGeometry> {
    public static final String PROPERTY_NAMESPACE = "property";
    private final Set<RenderMaterial> extraTextures = Sets.newHashSet();

    public void func_195410_a(IResourceManager resourceManager) {
    }

    public void registerTexture(RenderMaterial material) {
        this.extraTextures.add(material);
    }

    public TexturedModelGeometry read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
        ResourceLocation baseLoader = new ResourceLocation(modelContents.get("base_loader").getAsString());
        IModelGeometry modelGeometry = ModelLoaderRegistry.getModel((ResourceLocation)baseLoader, (JsonDeserializationContext)deserializationContext, (JsonObject)modelContents);
        return new TexturedModelGeometry(modelGeometry, this.extraTextures);
    }
}

