/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.oceanfloor;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;

public class ConfigOcean {
    private static final ForgeConfigSpec.Builder CFG = new ForgeConfigSpec.Builder();
    private static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec.IntValue DIRTSIZE;
    public static ForgeConfigSpec.IntValue DIRTSPREAD;
    public static ForgeConfigSpec.IntValue CLAYSPREAD;
    public static ForgeConfigSpec.IntValue CLAYSIZE;
    public static ForgeConfigSpec.IntValue SANDSIZE;
    public static ForgeConfigSpec.IntValue SANDSPREAD;
    public static ForgeConfigSpec.IntValue GRAVELSIZE;
    public static ForgeConfigSpec.IntValue GRAVELSPREAD;
    public static final String WALL = "####################################################################################";

    public static void setup() {
        Path path = FMLPaths.CONFIGDIR.get().resolve("oceanfloor.toml");
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        COMMON_CONFIG.setConfig((CommentedConfig)configData);
    }

    private static void initConfig() {
        CFG.comment(new String[]{WALL, "Features", WALL}).push("oceanfloor");
        CFG.comment(new String[]{WALL, " Dirt spawns in spand an gravel floors of ocean-type biomes", WALL}).push("dirt");
        DIRTSIZE = CFG.comment("Patch size").defineInRange("size", 16, 0, 64);
        DIRTSPREAD = CFG.comment("Spread").defineInRange("spread", 15, 1, 100);
        CFG.pop();
        CFG.comment(new String[]{WALL, " Clay spawns in sand and gravel floors of ocean-type biomes", WALL}).push("clay");
        CLAYSIZE = CFG.comment("Patch size").defineInRange("size", 32, 0, 64);
        CLAYSPREAD = CFG.comment("Spread").defineInRange("spread", 75, 1, 100);
        CFG.pop();
        CFG.comment(new String[]{WALL, " Sand spawns in gravel floors of ocean-type biomes", WALL}).push("sand");
        SANDSIZE = CFG.comment("Patch size").defineInRange("size", 22, 0, 64);
        SANDSPREAD = CFG.comment("Spread").defineInRange("spread", 45, 1, 100);
        CFG.pop();
        CFG.comment(new String[]{WALL, " Gravel + Coarse Dirt spawn in the stone caves below ocean-type biomes", WALL}).push("gravel");
        GRAVELSIZE = CFG.comment("Patch size").defineInRange("size", 16, 0, 64);
        GRAVELSPREAD = CFG.comment("Spread").defineInRange("spread", 16, 1, 100);
        CFG.pop();
        CFG.pop();
        COMMON_CONFIG = CFG.build();
    }

    static {
        ConfigOcean.initConfig();
    }
}

