/*
 * Decompiled with CFR 0.152.
 */
package team.creative.playerrevive;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.network.CreativeNetwork;
import team.creative.playerrevive.PlayerReviveConfig;
import team.creative.playerrevive.api.IBleeding;
import team.creative.playerrevive.cap.Bleeding;
import team.creative.playerrevive.cap.BleedingStorage;
import team.creative.playerrevive.client.ReviveEventClient;
import team.creative.playerrevive.packet.GiveUpPacket;
import team.creative.playerrevive.packet.HelperPacket;
import team.creative.playerrevive.packet.ReviveUpdatePacket;
import team.creative.playerrevive.server.PlayerReviveServer;
import team.creative.playerrevive.server.ReviveEventServer;

@Mod(value="playerrevive")
public class PlayerRevive {
    public static final Logger LOGGER = LogManager.getLogger((String)"playerrevive");
    public static final String MODID = "playerrevive";
    public static PlayerReviveConfig CONFIG;
    public static final CreativeNetwork NETWORK;
    public static final ResourceLocation BLEEDING_NAME;
    public static final SoundEvent DEATH_SOUND;
    public static final SoundEvent REVIVED_SOUND;
    @CapabilityInject(value=IBleeding.class)
    public static Capability<IBleeding> BLEEDING;

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{DEATH_SOUND, REVIVED_SOUND});
    }

    public PlayerRevive() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::client));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(SoundEvent.class, this::registerSounds);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void client(FMLClientSetupEvent event) {
        CreativeCoreClient.registerClientConfig((String)MODID);
        MinecraftForge.EVENT_BUS.register((Object)new ReviveEventClient());
    }

    private void init(FMLCommonSetupEvent event) {
        NETWORK.registerType(ReviveUpdatePacket.class);
        NETWORK.registerType(HelperPacket.class);
        NETWORK.registerType(GiveUpPacket.class);
        CONFIG = new PlayerReviveConfig();
        CreativeConfigRegistry.ROOT.registerValue(MODID, (Object)CONFIG);
        CapabilityManager.INSTANCE.register(IBleeding.class, (Capability.IStorage)new BleedingStorage(), Bleeding::new);
        MinecraftForge.EVENT_BUS.register((Object)new ReviveEventServer());
    }

    private void serverStarting(FMLServerStartingEvent event) {
        event.getServer().func_195571_aL().func_197054_a().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"revive").requires(x -> x.func_197034_c(2))).then(Commands.func_197056_a((String)"players", (ArgumentType)EntityArgument.func_197094_d()).executes(x -> {
            Collection players = EntityArgument.func_197090_e((CommandContext)x, (String)"players");
            for (ServerPlayerEntity player : players) {
                if (!PlayerReviveServer.getBleeding((PlayerEntity)player).isBleeding()) continue;
                PlayerReviveServer.revive((PlayerEntity)player);
            }
            return 0;
        })));
    }

    static {
        NETWORK = new CreativeNetwork("1.0", LOGGER, new ResourceLocation(MODID, "main"));
        BLEEDING_NAME = new ResourceLocation(MODID, "bleeding");
        DEATH_SOUND = (SoundEvent)new SoundEvent(new ResourceLocation(MODID, "death")).setRegistryName(new ResourceLocation(MODID, "death"));
        REVIVED_SOUND = (SoundEvent)new SoundEvent(new ResourceLocation(MODID, "revived")).setRegistryName(new ResourceLocation(MODID, "revived"));
        BLEEDING = null;
    }
}

