/*
 * Decompiled with CFR 0.152.
 */
package team.creative.playerrevive.cap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.playerrevive.PlayerRevive;
import team.creative.playerrevive.api.CombatTrackerClone;
import team.creative.playerrevive.api.DamageBledToDeath;
import team.creative.playerrevive.api.IBleeding;
import team.creative.playerrevive.packet.HelperPacket;

public class Bleeding
implements IBleeding {
    private boolean bleeding;
    private float progress;
    private int timeLeft;
    private int downedTime;
    private DamageSource lastSource;
    private CombatTrackerClone trackerClone;
    public final List<PlayerEntity> revivingPlayers = new ArrayList<PlayerEntity>();

    @Override
    public void tick(PlayerEntity player) {
        Iterator<PlayerEntity> iterator = this.revivingPlayers.iterator();
        while (iterator.hasNext()) {
            PlayerEntity helper = iterator.next();
            if (!((double)helper.func_70032_d((Entity)player) > PlayerRevive.CONFIG.maxDistance)) continue;
            PlayerRevive.NETWORK.sendToClient((CreativePacket)new HelperPacket(null, false), (ServerPlayerEntity)helper);
            iterator.remove();
        }
        if (this.revivingPlayers.isEmpty() || !PlayerRevive.CONFIG.haltBleedTime) {
            --this.timeLeft;
        }
        this.progress += (float)this.revivingPlayers.size() * PlayerRevive.CONFIG.progressPerPlayer;
        ++this.downedTime;
        if (PlayerRevive.CONFIG.exhaustion > 0.0f) {
            for (int i = 0; i < this.revivingPlayers.size(); ++i) {
                this.revivingPlayers.get(i).func_71020_j(PlayerRevive.CONFIG.exhaustion);
            }
        }
    }

    @Override
    public void forceBledOut() {
        this.bleeding = true;
        this.timeLeft = 0;
    }

    @Override
    public int downedTime() {
        return this.downedTime;
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Override
    public boolean revived() {
        return this.progress >= PlayerRevive.CONFIG.requiredReviveProgress;
    }

    @Override
    public boolean bledOut() {
        return this.bleeding && this.timeLeft <= 0;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("timeLeft", this.timeLeft);
        nbt.func_74776_a("progress", this.progress);
        nbt.func_74757_a("bleeding", this.bleeding);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.timeLeft = nbt.func_74762_e("timeLeft");
        this.progress = nbt.func_74760_g("progress");
        this.bleeding = nbt.func_74767_n("bleeding");
    }

    @Override
    public boolean isBleeding() {
        return this.bleeding;
    }

    @Override
    public void knockOut(PlayerEntity player, DamageSource source) {
        this.bleeding = true;
        this.progress = 0.0f;
        this.downedTime = 0;
        this.timeLeft = PlayerRevive.CONFIG.bleedTime;
        this.lastSource = source;
        this.trackerClone = new CombatTrackerClone(player.func_110142_aN());
    }

    @Override
    public void revive() {
        this.bleeding = false;
        this.progress = 0.0f;
        this.timeLeft = 0;
        this.downedTime = 0;
        this.lastSource = null;
        this.trackerClone = null;
    }

    @Override
    public int timeLeft() {
        return this.timeLeft;
    }

    @Override
    public List<PlayerEntity> revivingPlayers() {
        return this.revivingPlayers;
    }

    @Override
    public CombatTrackerClone getTrackerClone() {
        return this.trackerClone;
    }

    @Override
    public DamageSource getSource() {
        if (this.lastSource != null) {
            return this.lastSource;
        }
        return DamageBledToDeath.BLED_TO_DEATH;
    }
}

