/*
 * Decompiled with CFR 0.152.
 */
package team.creative.playerrevive.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.playerrevive.PlayerRevive;
import team.creative.playerrevive.api.IBleeding;
import team.creative.playerrevive.client.TensionSound;
import team.creative.playerrevive.packet.GiveUpPacket;
import team.creative.playerrevive.server.PlayerReviveServer;

@OnlyIn(value=Dist.CLIENT)
public class ReviveEventClient {
    public static Minecraft mc = Minecraft.func_71410_x();
    private static final Field handsBusy = ObfuscationReflectionHelper.findField(ClientPlayerEntity.class, (String)"field_184844_co");
    public boolean lastShader = false;
    public boolean lastHighTension = false;
    public static TensionSound sound;
    public static UUID helpTarget;
    public static boolean helpActive;
    private boolean addedEffect = false;
    private int giveUpTimer = 0;

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        IBleeding revive = PlayerReviveServer.getBleeding(event.player);
        if (revive.isBleeding() && event.player != ReviveEventClient.mc.field_71439_g) {
            event.player.func_213301_b(Pose.SWIMMING);
        }
    }

    @SubscribeEvent
    public void click(InputEvent.ClickInputEvent event) {
        IBleeding revive;
        ClientPlayerEntity player = ReviveEventClient.mc.field_71439_g;
        if (player != null && (revive = PlayerReviveServer.getBleeding((PlayerEntity)player)).isBleeding()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        ClientPlayerEntity player;
        if (event.phase == TickEvent.Phase.END && (player = ReviveEventClient.mc.field_71439_g) != null) {
            IBleeding revive = PlayerReviveServer.getBleeding((PlayerEntity)player);
            if (revive.isBleeding()) {
                if (ReviveEventClient.mc.field_71474_y.field_74312_F.func_151470_d()) {
                    if (this.giveUpTimer > 80) {
                        PlayerRevive.NETWORK.sendToServer((CreativePacket)new GiveUpPacket());
                        this.giveUpTimer = 0;
                    } else {
                        ++this.giveUpTimer;
                    }
                } else {
                    this.giveUpTimer = 0;
                }
            } else {
                this.giveUpTimer = 0;
            }
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.RenderTickEvent event) {
        ClientPlayerEntity player = ReviveEventClient.mc.field_71439_g;
        if (player != null) {
            IBleeding revive = PlayerReviveServer.getBleeding((PlayerEntity)player);
            if (!revive.isBleeding()) {
                PlayerEntity other;
                this.lastHighTension = false;
                if (this.lastShader) {
                    ReviveEventClient.mc.field_71460_t.func_175066_a(mc.func_175606_aa());
                    this.lastShader = false;
                }
                if (this.addedEffect) {
                    player.func_195063_d(Effects.field_76430_j);
                    try {
                        handsBusy.setBoolean(player, false);
                    }
                    catch (IllegalAccessException | IllegalArgumentException exception) {
                        // empty catch block
                    }
                    this.addedEffect = false;
                }
                if (sound != null) {
                    mc.func_147118_V().func_147683_b((ISound)sound);
                    sound = null;
                }
                if (helpActive && (other = player.field_70170_p.func_217371_b(helpTarget)) != null) {
                    ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
                    IBleeding bleeding = PlayerReviveServer.getBleeding(other);
                    list.add((ITextComponent)new TranslationTextComponent("playerrevive.gui.label.time_left", new Object[]{this.formatTime(bleeding.timeLeft())}));
                    list.add((ITextComponent)new StringTextComponent("" + bleeding.getProgress() + "/" + PlayerRevive.CONFIG.requiredReviveProgress));
                    ReviveEventClient.render(list);
                }
            } else {
                try {
                    player.func_213301_b(Pose.SWIMMING);
                    handsBusy.setBoolean(player, true);
                    player.func_195064_c(new EffectInstance(Effects.field_76430_j, 0, -10));
                    player.field_70737_aN = 0;
                    this.addedEffect = true;
                }
                catch (IllegalAccessException | IllegalArgumentException other) {
                    // empty catch block
                }
                if (revive.timeLeft() < 400) {
                    if (!this.lastHighTension) {
                        if (!PlayerRevive.CONFIG.disableMusic) {
                            mc.func_147118_V().func_147683_b((ISound)sound);
                            sound = new TensionSound(new ResourceLocation("playerrevive", "hightension"), PlayerRevive.CONFIG.musicVolume, 1.0f, false);
                            mc.func_147118_V().func_147682_a((ISound)sound);
                        }
                        this.lastHighTension = true;
                    }
                } else if (!this.lastShader) {
                    if (sound != null) {
                        mc.func_147118_V().func_147683_b((ISound)sound);
                    }
                    if (!PlayerRevive.CONFIG.disableMusic) {
                        sound = new TensionSound(new ResourceLocation("playerrevive", "tension"), PlayerRevive.CONFIG.musicVolume, 1.0f, true);
                        mc.func_147118_V().func_147682_a((ISound)sound);
                    }
                }
                if (!this.lastShader || ReviveEventClient.mc.field_71460_t.func_147706_e() == null) {
                    ReviveEventClient.mc.field_71460_t.func_175069_a(new ResourceLocation("shaders/post/blur.json"));
                    this.lastShader = true;
                }
                ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
                IBleeding bleeding = PlayerReviveServer.getBleeding((PlayerEntity)player);
                list.add((ITextComponent)new TranslationTextComponent("playerrevive.gui.label.time_left", new Object[]{this.formatTime(bleeding.timeLeft())}));
                list.add((ITextComponent)new StringTextComponent("" + bleeding.getProgress() + "/" + PlayerRevive.CONFIG.requiredReviveProgress));
                list.add((ITextComponent)new TranslationTextComponent("playerrevive.gui.hold", new Object[]{ReviveEventClient.mc.field_71474_y.field_74312_F.getKey().func_237520_d_(), (80 - this.giveUpTimer) / 20}));
                ReviveEventClient.render(list);
            }
        }
    }

    public static void render(List<ITextComponent> list) {
        String text;
        int i;
        int space = 15;
        int width = 0;
        for (i = 0; i < list.size(); ++i) {
            text = list.get(i).getString();
            width = Math.max(width, ReviveEventClient.mc.field_71466_p.func_78256_a(text) + 10);
        }
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
        for (i = 0; i < list.size(); ++i) {
            text = list.get(i).getString();
            ReviveEventClient.mc.field_71466_p.func_238405_a_(new MatrixStack(), text, (float)(mc.func_228018_at_().func_198107_o() / 2 - ReviveEventClient.mc.field_71466_p.func_78256_a(text) / 2), (float)(mc.func_228018_at_().func_198087_p() / 2 + (list.size() / 2 * space - space * (i + 1))), 0xFCFCFC);
        }
        RenderSystem.enableDepthTest();
    }

    public String formatTime(int timeLeft) {
        int lengthOfMinute = 1200;
        int lengthOfHour = lengthOfMinute * 60;
        int hours = timeLeft / lengthOfHour;
        int minutes = (timeLeft -= hours * lengthOfHour) / lengthOfMinute;
        int seconds = (timeLeft -= minutes * lengthOfMinute) / 20;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    static {
        helpActive = false;
    }
}

