/*
 * Decompiled with CFR 0.152.
 */
package team.creative.playerrevive.server;

import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.management.ProfileBanEntry;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.playerrevive.PlayerRevive;
import team.creative.playerrevive.api.CombatTrackerClone;
import team.creative.playerrevive.api.IBleeding;
import team.creative.playerrevive.api.event.PlayerBleedOutEvent;
import team.creative.playerrevive.api.event.PlayerRevivedEvent;
import team.creative.playerrevive.cap.Bleeding;
import team.creative.playerrevive.packet.HelperPacket;
import team.creative.playerrevive.packet.ReviveUpdatePacket;

public class PlayerReviveServer {
    public static IBleeding getBleeding(PlayerEntity player) {
        return (IBleeding)player.getCapability(PlayerRevive.BLEEDING).orElseGet(Bleeding::new);
    }

    public static void sendUpdatePacket(PlayerEntity player) {
        ReviveUpdatePacket packet = new ReviveUpdatePacket(player);
        PlayerRevive.NETWORK.sendToClientTracking((CreativePacket)packet, (Entity)player);
        PlayerRevive.NETWORK.sendToClient((CreativePacket)packet, (ServerPlayerEntity)player);
    }

    public static void startBleeding(PlayerEntity player, DamageSource source) {
        PlayerReviveServer.getBleeding(player).knockOut(player, source);
        PlayerReviveServer.sendUpdatePacket(player);
    }

    private static void resetPlayer(PlayerEntity player, IBleeding revive) {
        player.field_71075_bZ.field_75102_a = player.func_184812_l_();
        player.func_184224_h(false);
        for (PlayerEntity helper : revive.revivingPlayers()) {
            PlayerRevive.NETWORK.sendToClient((CreativePacket)new HelperPacket(null, false), (ServerPlayerEntity)helper);
        }
        revive.revivingPlayers().clear();
        PlayerReviveServer.sendUpdatePacket(player);
    }

    public static void revive(PlayerEntity player) {
        IBleeding revive = PlayerReviveServer.getBleeding(player);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerRevivedEvent(player, revive));
        revive.revive();
        PlayerReviveServer.resetPlayer(player, revive);
        PlayerRevive.CONFIG.sounds.revived.play((Entity)player, SoundCategory.PLAYERS);
        PlayerReviveServer.sendUpdatePacket(player);
    }

    public static void kill(PlayerEntity player) {
        IBleeding revive = PlayerReviveServer.getBleeding(player);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerBleedOutEvent(player, revive));
        DamageSource source = revive.getSource();
        CombatTrackerClone trackerClone = revive.getTrackerClone();
        if (trackerClone != null) {
            trackerClone.overwriteTracker(player.func_110142_aN());
        }
        player.func_70606_j(0.0f);
        revive.forceBledOut();
        player.func_70645_a(source);
        PlayerReviveServer.resetPlayer(player, revive);
        PlayerRevive.CONFIG.sounds.death.play((Entity)player, SoundCategory.PLAYERS);
        if (PlayerRevive.CONFIG.banPlayerAfterDeath) {
            try {
                player.func_184102_h().func_184103_al().func_152608_h().func_152687_a((UserListEntry)new ProfileBanEntry(player.func_146103_bH()));
                player.func_184102_h().func_184103_al().func_152608_h().func_152678_f();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        PlayerReviveServer.sendUpdatePacket(player);
    }

    public static void removePlayerAsHelper(PlayerEntity player) {
        for (ServerPlayerEntity member : player.func_184102_h().func_184103_al().func_181057_v()) {
            IBleeding revive = PlayerReviveServer.getBleeding((PlayerEntity)member);
            revive.revivingPlayers().remove(player);
        }
    }
}

