/*
 * Decompiled with CFR 0.152.
 */
package team.creative.playerrevive.server;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.playerrevive.PlayerRevive;
import team.creative.playerrevive.api.DamageBledToDeath;
import team.creative.playerrevive.api.IBleeding;
import team.creative.playerrevive.cap.Bleeding;
import team.creative.playerrevive.packet.HelperPacket;
import team.creative.playerrevive.server.PlayerReviveServer;

public class ReviveEventServer {
    public static boolean isReviveActive(Entity player) {
        return player.func_184102_h().func_71344_c();
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side == LogicalSide.SERVER && ReviveEventServer.isReviveActive((Entity)event.player)) {
            PlayerEntity player = event.player;
            if (!player.func_70089_S()) {
                return;
            }
            IBleeding revive = PlayerReviveServer.getBleeding(player);
            if (revive.isBleeding()) {
                revive.tick(player);
                if (revive.downedTime() % 5 == 0) {
                    PlayerReviveServer.sendUpdatePacket(player);
                }
                if (PlayerRevive.CONFIG.affectFood) {
                    player.func_71024_bL().func_75114_a(PlayerRevive.CONFIG.foodAfterRevive);
                }
                player.func_70606_j((float)PlayerRevive.CONFIG.healthAfterRevive);
                player.field_71075_bZ.field_75102_a = true;
                player.func_184224_h(true);
                if (revive.revived()) {
                    PlayerReviveServer.revive(player);
                } else if (revive.bledOut()) {
                    PlayerReviveServer.kill(player);
                }
            }
        }
    }

    @SubscribeEvent
    public void playerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        IBleeding revive = PlayerReviveServer.getBleeding(event.getPlayer());
        if (revive.isBleeding()) {
            PlayerReviveServer.kill(event.getPlayer());
        }
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            PlayerReviveServer.removePlayerAsHelper(event.getPlayer());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void playerInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getTarget() instanceof PlayerEntity && !event.getEntityLiving().field_70170_p.field_72995_K) {
            PlayerEntity target = (PlayerEntity)event.getTarget();
            PlayerEntity helper = event.getPlayer();
            IBleeding revive = PlayerReviveServer.getBleeding(target);
            if (revive.isBleeding()) {
                PlayerReviveServer.removePlayerAsHelper(helper);
                revive.revivingPlayers().add(helper);
                PlayerRevive.NETWORK.sendToClient((CreativePacket)new HelperPacket(target.func_110124_au(), true), (ServerPlayerEntity)helper);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void playerDamage(LivingHurtEvent event) {
        PlayerEntity player;
        IBleeding revive;
        if (event.getEntityLiving() instanceof PlayerEntity && (revive = PlayerReviveServer.getBleeding(player = (PlayerEntity)event.getEntityLiving())).isBleeding() && (event.getSource() != DamageBledToDeath.BLED_TO_DEATH && !PlayerRevive.CONFIG.bypassDamageSources.contains(event.getSource().field_76373_n) || revive.bledOut())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void playerDied(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && ReviveEventServer.isReviveActive((Entity)event.getEntityLiving()) && !event.getEntityLiving().field_70170_p.field_72995_K && event.getSource() != DamageBledToDeath.BLED_TO_DEATH && !PlayerRevive.CONFIG.bypassDamageSources.contains(event.getSource().field_76373_n)) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            IBleeding revive = PlayerReviveServer.getBleeding(player);
            if (revive.bledOut()) {
                return;
            }
            PlayerReviveServer.removePlayerAsHelper(player);
            PlayerRevive.NETWORK.sendToClient((CreativePacket)new HelperPacket(null, false), (ServerPlayerEntity)player);
            PlayerReviveServer.startBleeding(player, event.getSource());
            player.field_71075_bZ.field_75102_a = true;
            player.func_184224_h(true);
            if (player.func_184218_aH()) {
                player.func_184210_p();
            }
            event.setCanceled(true);
            if (PlayerRevive.CONFIG.affectFood) {
                player.func_71024_bL().func_75114_a(PlayerRevive.CONFIG.foodAfterRevive);
            }
            player.func_70606_j((float)PlayerRevive.CONFIG.healthAfterRevive);
            if (!PlayerRevive.CONFIG.disableBleedingMessage) {
                player.func_184102_h().func_184103_al().func_232641_a_((ITextComponent)new TranslationTextComponent("playerrevive.chat.bleeding", new Object[]{player.func_145748_c_()}), ChatType.SYSTEM, Util.field_240973_b_);
            }
        }
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(PlayerRevive.BLEEDING_NAME, new ICapabilityProvider(){
                private LazyOptional<IBleeding> bleed = LazyOptional.of(Bleeding::new);

                public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
                    return PlayerRevive.BLEEDING.orEmpty(cap, this.bleed);
                }
            });
        }
    }
}

